/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.sql;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import oracle.bpm.component.Instantiator;
import oracle.bpm.connector.ConnectorException;
import oracle.bpm.connector.JDBCHelper;
import oracle.bpm.jdbc.DatabaseManager;
import oracle.bpm.lang.ComponentExecutionException;
import oracle.bpm.lang.Invokeable;
import oracle.bpm.lang.RuntimeExceptionShell;
import oracle.bpm.log.Log;
import oracle.bpm.sql.JDBC11SQLQueryObject;
import oracle.bpm.sql.QueryObject;

public class SQLInstantiator
extends Instantiator {
    private String moduleName;

    public SQLInstantiator(String moduleName) {
        this.moduleName = moduleName;
    }

    @Override
    public Invokeable instantiate(String qualifiedName, String componentName) throws ClassNotFoundException, ComponentExecutionException {
        try {
            String type = componentName.substring(0, componentName.indexOf("#"));
            if (type.startsWith("oracle.bpm.sql.QueryObject")) {
                type = this.getQueryClass();
            }
            Class<?> clazz = Class.forName(type);
            Constructor<?> constr = clazz.getConstructor(String.class, String.class);
            return (Invokeable)constr.newInstance(this.moduleName, componentName);
        }
        catch (InstantiationException e) {
            throw new RuntimeExceptionShell(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeExceptionShell(e.getTargetException());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeExceptionShell(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeExceptionShell(e);
        }
    }

    Connection getConnection() {
        try {
            return JDBCHelper.getConnection(this.moduleName);
        }
        catch (ConnectorException e) {
            Log.logFatal(e);
            return null;
        }
    }

    private String getQueryClass() throws ComponentExecutionException {
        try {
            DatabaseManager mgr = JDBCHelper.getDatabaseManager(this.moduleName);
            if (!mgr.supportsJDBC20()) {
                return JDBC11SQLQueryObject.class.getName();
            }
            return QueryObject.class.getName();
        }
        catch (ConnectorException e) {
            throw new ComponentExecutionException(e);
        }
    }
}

