/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.sql;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import oracle.bpm.lang.Time;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.log.Log;

class ResourceRef<T>
extends WeakReference<T> {
    private Vector<ResourceRef> children_d;
    private int childrenCount_d;
    private String classname_d;
    private boolean closed_d;
    private Time creationTime_d;
    private String info_d = "";
    private Object jdbcResource_d;
    private ResourceRef parent_d;
    private String stackTrace_d;
    private String thread_d = Thread.currentThread().getName();

    ResourceRef(T managedResource, Object jdbcResource, ReferenceQueue<? super T> queue) {
        super(managedResource, queue);
        this.creationTime_d = Time.now();
        this.classname_d = jdbcResource.getClass().getName();
        this.jdbcResource_d = jdbcResource;
        this.childrenCount_d = 0;
        this.children_d = new Vector();
    }

    public String toString() {
        String text = "";
        text = text + "Resource class      : " + this.classname_d + "\n";
        text = text + "Creation thread     : " + this.thread_d + "\n";
        text = text + "Creation time       : " + this.creationTime_d + "\n";
        text = text + "Creation stackTrace : \n" + this.stackTrace_d + "\n";
        text = text + "Info                : \n" + this.info_d + "\n";
        return text;
    }

    synchronized Vector<ResourceRef> getChildren() {
        return this.children_d;
    }

    synchronized int getChildrenCount() {
        return this.childrenCount_d;
    }

    String getClassName() {
        return this.classname_d;
    }

    boolean isClosed() {
        return this.closed_d || this.parent_d != null && this.parent_d.isClosed();
    }

    Time getCreationTime() {
        return this.creationTime_d;
    }

    void setInfo(String info) {
        this.info_d = info;
    }

    String getInfo() {
        return this.info_d;
    }

    void setParent(ResourceRef parent) {
        this.parent_d = parent;
    }

    void setStackTrace(String stackTrace) {
        this.stackTrace_d = stackTrace;
    }

    String getStackTrace() {
        return this.stackTrace_d;
    }

    String getThreadName() {
        return this.thread_d;
    }

    void close() {
        this.closed_d = true;
        if (this.parent_d != null) {
            this.parent_d.closeChild(this);
        }
    }

    synchronized void closeChild(ResourceRef ref) {
        --this.childrenCount_d;
        this.removeChild(ref);
    }

    void closeJDBCResource() throws SQLException {
        if (this.jdbcResource_d instanceof Connection) {
            Connection conn = (Connection)this.jdbcResource_d;
            conn.close();
        } else if (this.jdbcResource_d instanceof Statement) {
            Statement stmt = (Statement)this.jdbcResource_d;
            stmt.close();
        } else if (this.jdbcResource_d instanceof ResultSet) {
            ResultSet result = (ResultSet)this.jdbcResource_d;
            result.close();
        } else {
            throw new RuntimeException("Unknown jdbc resource");
        }
    }

    synchronized void openChild(ResourceRef ref) {
        ++this.childrenCount_d;
        this.children_d.add(ref);
    }

    void wasCollected() {
        if (!this.isClosed()) {
            try {
                Log.logWarning(LibMsg.RESOURCE_NOT_CLOSED(this.toString()));
                this.closeJDBCResource();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private void removeChild(ResourceRef ref) {
        int length = this.children_d.size();
        for (int i = length - 1; i >= 0; --i) {
            if (this.children_d.get(i) != ref) continue;
            this.children_d.remove(i);
            break;
        }
    }
}

