/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.sql;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import oracle.bpm.http.AbstractHttpCommand;
import oracle.bpm.http.HttpCommandServer;
import oracle.bpm.http.HttpRequest;
import oracle.bpm.http.HttpResponse;
import oracle.bpm.lang.LowResolutionTimer;
import oracle.bpm.lang.LowResolutionTimerListener;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.log.Log;
import oracle.bpm.sql.ManagedConnection;
import oracle.bpm.sql.ResourceRef;
import oracle.bpm.util.ObjectWatch;

public class JDBCResourceMonitor
implements LowResolutionTimerListener {
    private ReferenceQueue queue_d;
    private List<ResourceRef<Object>> resources_d = new Vector<ResourceRef<Object>>();
    private static JDBCResourceMonitor default_sd;
    private static boolean enabled_d;

    public JDBCResourceMonitor() {
        this.queue_d = new ReferenceQueue();
        LowResolutionTimer timer_d = new LowResolutionTimer(60);
        timer_d.add(this);
        timer_d.start();
        HttpCommandServer.getDefault().register(new JDBCResourceWatch());
    }

    public static synchronized JDBCResourceMonitor getDefault() {
        if (default_sd == null) {
            default_sd = new JDBCResourceMonitor();
        }
        return default_sd;
    }

    public static void setEnabled(boolean enabled) {
        enabled_d = enabled;
    }

    public static boolean isEnabled() {
        return enabled_d;
    }

    public synchronized void closeCollectedResources() {
        Reference ref;
        block0: while ((ref = this.queue_d.poll()) != null) {
            ResourceRef resource = (ResourceRef)ref;
            resource.wasCollected();
            int length = this.resources_d.size();
            for (int i = length - 1; i >= 0; --i) {
                if (this.resources_d.get(i) != resource) continue;
                this.resources_d.remove(i);
                continue block0;
            }
        }
    }

    public synchronized void shutdown() {
        Iterator<ResourceRef<Object>> it = this.resources_d.iterator();
        while (it.hasNext()) {
            ResourceRef<Object> ref = it.next();
            this.close(ref);
            it.remove();
        }
    }

    @Override
    public void timerFired(LowResolutionTimer timer) {
        this.closeCollectedResources();
    }

    ReferenceQueue getQueue() {
        return this.queue_d;
    }

    ResourceRef registerResource(ManagedConnection connection, Object jdbcRes) {
        ResourceRef<ManagedConnection> ref = new ResourceRef<ManagedConnection>(connection, jdbcRes, this.queue_d);
        this.resources_d.add(ref);
        return ref;
    }

    private void close(ResourceRef<Object> resource) {
        if (!resource.isClosed()) {
            Log.logWarning(LibMsg.RESOURCE_NOT_CLOSED(resource.toString()));
            resource.wasCollected();
        }
    }

    static {
        enabled_d = false;
    }

    public class JDBCResourceWatch
    extends AbstractHttpCommand {
        public JDBCResourceWatch() {
            super("jdbcconnections", "Open jdbc connections", "jdbc connections");
        }

        @Override
        public void process(HttpRequest request, HttpResponse response) throws IOException {
            try {
                List children;
                ObjectWatch def = ObjectWatch.getDefault();
                String childrenId = request.getArguments().get("childrenId");
                if (childrenId == null) {
                    children = JDBCResourceMonitor.this.resources_d;
                } else {
                    Long id = Long.valueOf(childrenId);
                    children = (List)def.getObjectFromPlainId(id);
                    if (children == null) {
                        children = new ArrayList();
                    }
                }
                StringBuffer result = new StringBuffer(256);
                result.append("<html><body bgcolor=white><h2>" + this.getDescription() + "</h2>\n\n");
                Object[] resources = children.toArray();
                result.append("<table border=1>");
                result.append("<tr>");
                result.append("<th>JDBC Resource</th>");
                result.append("<th>Thread</th>");
                result.append("<th>Creation Time</th>");
                result.append("<th>Open children</th>");
                result.append("<th>Stack trace</th>");
                result.append("<th>Info</th>");
                result.append("</tr>\n");
                for (int i = 0; i < resources.length; ++i) {
                    ResourceRef ref = (ResourceRef)resources[i];
                    result.append("<tr>");
                    String clname = ref.getClassName();
                    int index = clname.lastIndexOf(46);
                    if (index != -1) {
                        clname = clname.substring(index + 1);
                    }
                    String id = "<a href=/" + this.getName() + "?childrenId=" + def.getPlainId(ref.getChildren()) + ">" + clname + "</a>";
                    result.append("<td>" + id + "</td>");
                    result.append("<td>" + ref.getThreadName() + "</td>");
                    result.append("<td>" + ref.getCreationTime() + "</td>");
                    result.append("<td>" + ref.getChildrenCount() + "</td>");
                    id = def.getId(ref.getStackTrace(), "jdbc", "stack trace");
                    result.append("<td>" + id + "</td>");
                    id = def.getId(ref.getInfo(), "jdbc", "info");
                    result.append("<td>" + id + "</td>");
                    result.append("</tr>\n");
                }
                result.append("</table></body></html>");
                response.getOutput().write(result.toString().getBytes());
                response.getOutput().flush();
            }
            catch (Exception e) {
                e.printStackTrace(response.getPrintStream());
            }
        }
    }
}

