/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.servlet;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

public class UrlUtils {
    private UrlUtils() {
    }

    public static String addParam(String url, String key, int value) {
        return UrlUtils.addParam(url, key, Integer.toString(value));
    }

    public static String addParam(String url, String key, boolean value) {
        return UrlUtils.addParam(url, key, Boolean.toString(value));
    }

    public static String addParam(String url, String key, String value) {
        String separator = "?";
        if (url.indexOf(63) != -1) {
            separator = "&";
        }
        try {
            value = URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("Could not encode parameter", e);
        }
        StringBuffer newUrl = new StringBuffer(url);
        return newUrl.append(separator).append(key).append("=").append(value).toString();
    }

    public static String removeParam(String url, String value) {
        String initialURL = url;
        while (url.indexOf(value) != -1) {
            initialURL = url.substring(0, url.indexOf(value));
            String remainURL = url.substring(url.indexOf(value), url.length());
            if (remainURL.indexOf(38) != -1) {
                remainURL = remainURL.substring(remainURL.indexOf(38) + 1, remainURL.length());
                initialURL = initialURL + remainURL;
            }
            if (initialURL.endsWith("?") || initialURL.endsWith("&")) {
                initialURL = initialURL.substring(0, initialURL.length() - 1);
            }
            url = initialURL;
        }
        return initialURL;
    }

    public static Map<String, String> getParams(String url) {
        HashMap<String, String> result = new HashMap<String, String>();
        String[] urlParts = UrlUtils.splitUrl(url);
        if (urlParts.length <= 1) {
            return result;
        }
        String paramsPart = urlParts[1].substring(0, urlParts[1].length());
        for (String param : paramsPart.split("&")) {
            String[] nameValue = param.split("=");
            result.put(nameValue[0], nameValue[1]);
        }
        return result;
    }

    public static String getParamsAsUrl(String url) {
        return UrlUtils.splitUrl(url).length == 2 ? "?" + UrlUtils.splitUrl(url)[1] : "";
    }

    public static String removeParams(String url) {
        return UrlUtils.splitUrl(url)[0];
    }

    private static String[] splitUrl(String url) {
        return url.split("\\?");
    }
}

