/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lib;

import java.net.URI;
import java.util.Collections;
import java.util.Map;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.lib.Expression;
import oracle.bpm.lib.ExpressionLanguage;
import oracle.bpm.lib.ExpressionMode;
import oracle.bpm.lib.InvalidExpression;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class XPathExpression
implements Expression {
    @NotNull
    private final String expression;
    private ExpressionMode expressionMode;
    @NotNull
    private final Map<String, URI> namespaces;

    public XPathExpression(@NonNls @NotNull String expression) {
        if (expression == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/lib/XPathExpression.<init> must not be null");
        }
        this(expression, Collections.emptyMap());
    }

    public XPathExpression(@NotNull String expression, @NotNull Map<String, URI> namespaces) {
        if (expression == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/lib/XPathExpression.<init> must not be null");
        }
        if (namespaces == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/lib/XPathExpression.<init> must not be null");
        }
        this.expressionMode = ExpressionMode.XPATH;
        this.expression = expression;
        this.namespaces = CollectionUtils.immutableMap(namespaces);
    }

    public static XPathExpression createConstantExpression(@NotNull String content) {
        if (content == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/lib/XPathExpression.createConstantExpression must not be null");
        }
        return new XPathExpression('\'' + content + '\'');
    }

    public static String fromXPathLiteral(String xpathLiteral) {
        String retVal = xpathLiteral;
        if (xpathLiteral.startsWith("'") && xpathLiteral.endsWith("'")) {
            retVal = xpathLiteral.substring(1, xpathLiteral.length() - 1);
        }
        return retVal;
    }

    public String toString() {
        return "XPathExpression{expression='" + this.expression + '\'' + ", namespaces=" + this.namespaces + '}';
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String getExpressionValue() {
        String string = this.expression;
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lib/XPathExpression.getExpressionValue must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Map<String, URI> getNamespaces() {
        Map<String, URI> map = this.namespaces;
        if (map == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lib/XPathExpression.getNamespaces must not return null");
        }
        return map;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public ExpressionLanguage getLanguage() {
        ExpressionLanguage expressionLanguage = ExpressionLanguage.XPATH;
        if (expressionLanguage == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lib/XPathExpression.getLanguage must not return null");
        }
        return expressionLanguage;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public ExpressionMode getMode() {
        ExpressionMode expressionMode = this.expressionMode;
        if (expressionMode == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lib/XPathExpression.getMode must not return null");
        }
        return expressionMode;
    }

    @Override
    public void setMode(@NotNull ExpressionMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/lib/XPathExpression.setMode must not be null");
        }
        this.expressionMode = mode;
    }

    @Override
    public boolean isInvalidExpression() {
        return false;
    }

    @Override
    public InvalidExpression asInvalidExpression() {
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof XPathExpression)) {
            return false;
        }
        XPathExpression that = (XPathExpression)o;
        return this.expression.equals(that.getExpressionValue()) && ((Object)this.namespaces).equals(that.getNamespaces()) && this.expressionMode.equals(that.expressionMode);
    }

    public int hashCode() {
        int result = this.expression.hashCode();
        result = 31 * result + this.expressionMode.hashCode();
        result = 31 * result + ((Object)this.namespaces).hashCode();
        return result;
    }
}

