/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lib;

import java.io.Serializable;
import java.util.Locale;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.resources.I18nProvider;
import oracle.bpm.resources.Msg;

public enum ExpressionMode implements I18nProvider,
Serializable
{
    SIMPLE("simple", LibMsg.SIMPLE),
    XPATH("xpath", LibMsg.XPATH),
    TEXT("text", LibMsg.TEXT),
    XML_LITERAL("xml", LibMsg.XML_LITERAL),
    NUMBER("number", LibMsg.NUMBER);

    private Msg msg;
    private String id;

    private ExpressionMode(String id, Msg msg) {
        this.id = id;
        this.msg = msg;
    }

    @Override
    public String getString() {
        return this.msg.getString();
    }

    @Override
    public String getString(Locale locale) {
        return this.msg.getString(locale);
    }

    public Msg getMsg() {
        return this.msg;
    }

    public String getId() {
        return this.id;
    }

    public static ExpressionMode fromId(String modeId) {
        ExpressionMode result = null;
        for (ExpressionMode expressionMode : ExpressionMode.values()) {
            if (!expressionMode.getId().equalsIgnoreCase(modeId)) continue;
            result = expressionMode;
            break;
        }
        return result;
    }
}

