/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.lang.ArrayTypeDescription;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.ComponentExecutionException;
import oracle.bpm.lang.ComponentType;
import oracle.bpm.lang.EnumTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.ObjectTypeDescriptionException;
import oracle.bpm.lang.SchemaObject;
import oracle.bpm.lang.ServiceObject;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.SuperType;
import oracle.bpm.lang.TransformTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.XmlTypeDescription;
import oracle.bpm.log.Log;
import oracle.bpm.type.Argument;
import oracle.bpm.type.SchemaObjectFactory;
import oracle.bpm.type.ServiceObjectFactory;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.TypeUtils;
import oracle.bpm.type.Variable;
import oracle.bpm.util.Locales;
import oracle.bpm.xobject.presentationmodel.XFormPresentationModel;
import org.jetbrains.annotations.NotNull;

public class XObjectTypeDescription
extends ObjectTypeDescription {
    private Map<String, XFormPresentationModel> presentations;
    private Map<String, ResourceValue> resources;
    public static final String DOT_INTERFACE = ".Interface";
    public static final String DEFAULT_PRESENTATION_PROPERTY = "defaultPresentation";
    public static final String PRESENTATION_PROPERTY = "presentation";
    public static final String LEGACY_XO = "legacy";
    public static final String DEFAULT_PRESENTATION = "defaultPresentation";
    public static final String PRESENTATION_NAMES = "presentationNames";
    public static final int SINGLELINE_RESOURCE = 0;
    public static final int MULTILINE_RESOURCE = 1;

    public XObjectTypeDescription(String classname) {
        this(classname, false);
    }

    public XObjectTypeDescription(String classname, boolean instanciable) {
        this(classname, 11);
        if (instanciable) {
            XObjectTypeDescription.addConstructors(this);
        }
    }

    private XObjectTypeDescription() {
        this("", false);
    }

    private XObjectTypeDescription(@NotNull String cName, int kind) {
        if (cName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/lang/XObjectTypeDescription.<init> must not be null");
        }
        super(cName, kind, false);
        this.setComponentType(ComponentType.XOBJECT.getText());
        this.setPresentable(false);
        this.addModifier(0x10000000L);
    }

    public static XObjectTypeDescription create(String classname, int kind) {
        assert (kind == 11 || kind == 17);
        return new XObjectTypeDescription(classname, kind);
    }

    public static boolean isGroupAttribute(AttributeTypeDescription attribute) {
        TypeDescription group;
        TypeDescription td;
        if (attribute != null && (td = attribute.getResultType()).isArray() && (group = td.getElementType()) instanceof ObjectTypeDescription) {
            ObjectTypeDescription otd = (ObjectTypeDescription)group;
            if (ComponentType.XOBJECT.getText().equals(otd.getComponentType()) && otd.getParent().equals(attribute.getParent())) {
                return true;
            }
        }
        return false;
    }

    public static String getValidValuesMethodSignature(ObjectTypeDescription otd, AttributeTypeDescription atd) {
        String methodSignature = null;
        String vvMethodName = atd.getName() + "ValidValues";
        MethodTypeDescription method = otd.findMethod(vvMethodName);
        if (method != null) {
            methodSignature = method.getJavaSignature();
        }
        return methodSignature;
    }

    public static void addConstructors(ObjectTypeDescription obj) {
        boolean inner;
        TypeDescription parent = obj.getParent();
        MethodTypeDescription constr = obj.findMethod(obj.getName());
        boolean bl = inner = parent != null && parent instanceof XObjectTypeDescription;
        if (inner && constr != null) {
            constr.setModifiers(constr.getModifiers() | 0x2000L | 0x100L);
        } else if (constr == null) {
            MethodTypeDescription constructor = obj.createConstructor();
            constructor.setModifiers(constructor.getModifiers() | 0x100L);
            if (inner) {
                constructor.setModifiers(constructor.getModifiers() | 0x2000L);
            }
            obj.addMember(constructor);
        }
    }

    public static TypeDescription replaceType(TypeDescription tree, Map<String, ObjectTypeDescription> replacements, boolean ourTree) {
        TypeDescription result;
        String text;
        String string = text = tree != null ? tree.getText() : "";
        if (tree == null) {
            result = null;
        } else if (replacements.containsKey(text)) {
            result = replacements.get(text);
        } else if (tree.isArray()) {
            ArrayTypeDescription arrayType = (ArrayTypeDescription)tree;
            TypeDescription elementType = tree.getElementType();
            TypeDescription newElementType = XObjectTypeDescription.replaceType(elementType, replacements, ourTree);
            TypeDescription indexType = tree.getIndexType();
            TypeDescription newIndexType = XObjectTypeDescription.replaceType(indexType, replacements, ourTree);
            result = newElementType != elementType || indexType != newIndexType ? new ArrayTypeDescription(newElementType, newIndexType, arrayType.isOrdered(), arrayType.isPrimitive(), arrayType.getJavaType()) : tree;
        } else if (tree.isObject() && ourTree) {
            for (SuperType superType : tree.getSuperTypes()) {
                TypeDescription sourceType = superType.getType();
                if (!sourceType.isModule()) {
                    superType.setType(XObjectTypeDescription.replaceType(sourceType, replacements, ourTree));
                    continue;
                }
                Log.logSevere(new IllegalStateException("Supertype " + sourceType.getText() + " is a Module and cannot be declared"));
            }
            int memberCount = tree.getMemberCount();
            for (int i = 0; i < memberCount; ++i) {
                MethodTypeDescription member = tree.getMemberType(i);
                do {
                    int argc = member.getArgumentCount();
                    for (int j = 0; j < argc; ++j) {
                        Argument arg = member.getArgument(j);
                        TypeDescription argType = arg.getType();
                        arg.setType(XObjectTypeDescription.replaceType(argType, replacements, false));
                    }
                    TypeDescription resultType = member.getResultType();
                    member.setResultType(XObjectTypeDescription.replaceType(resultType, replacements, false));
                    for (Variable var : member.getVariables()) {
                        TypeDescription varType = var.getType();
                        var.setType(XObjectTypeDescription.replaceType(varType, replacements, false));
                    }
                } while ((member = member.getNextMethod()) != null);
            }
            ObjectTypeDescription objectType = tree.asObject();
            int innerCount = objectType.getInnerTypeCount();
            for (int i = 0; i < innerCount; ++i) {
                ObjectTypeDescription innerType = objectType.getInnerType(i);
                innerType.setParent(objectType);
                XObjectTypeDescription.replaceType(innerType, replacements, ourTree);
            }
            result = tree;
        } else {
            result = tree;
        }
        return result;
    }

    @Override
    public EnumTypeDescription asEnum() {
        XmlTypeDescription otd;
        if (this.isEnum() && (otd = TypeUtils.getModelObject(this)) != null) {
            return otd.asEnum();
        }
        return super.asEnum();
    }

    public String[] getAllAttributesName() {
        return this.getAllAttributesName(true);
    }

    public String[] getAllAttributesName(boolean groupsIncluded) {
        MethodTypeDescription[] attribs;
        ArrayList<String> list = new ArrayList<String>();
        for (MethodTypeDescription attrib : attribs = this.getMembers(18)) {
            if (!groupsIncluded && XObjectTypeDescription.isGroupAttribute(attrib.asAttribute())) continue;
            list.add(attrib.getName());
        }
        return list.toArray(new String[list.size()]);
    }

    public void setDefaultPresentationName(String name) {
        this.setProperty("defaultPresentation", name);
        this.firePropertyChanged("defaultPresentation");
    }

    public String getDefaultPresentationName() {
        return this.getProperty("defaultPresentation");
    }

    public boolean isGroupAttribute(String name) {
        AttributeTypeDescription member = this.findAttribute(name);
        return member != null && XObjectTypeDescription.isGroupAttribute(member);
    }

    @Override
    public Class getJavaClass() {
        return null;
    }

    @Override
    public String getJavaSignature() {
        return 'L' + this.getJavaType() + ';';
    }

    @Override
    public boolean isBpmObject() {
        return true;
    }

    public void setPModel(XFormPresentationModel pres, String name) {
        if (this.presentations == null) {
            this.presentations = new HashMap<String, XFormPresentationModel>();
        }
        this.presentations.put(name, pres);
        if (this.getDefaultPresentationName() == null) {
            this.setDefaultPresentationName(name);
        }
        this.updatePresentationNames();
        this.fireTypeChanged();
        this.fireRelationAdded(PRESENTATION_PROPERTY, pres);
    }

    public XFormPresentationModel[] getPModels() {
        if (this.presentations == null) {
            return new XFormPresentationModel[0];
        }
        ArrayList<XFormPresentationModel> temp = new ArrayList<XFormPresentationModel>(this.presentations.values());
        Collections.sort(temp, new Comparator<XFormPresentationModel>(){

            @Override
            public int compare(XFormPresentationModel o1, XFormPresentationModel o2) {
                return o1.getPresentationName().compareTo(o2.getPresentationName());
            }
        });
        return temp.toArray(new XFormPresentationModel[temp.size()]);
    }

    public void setPresentable(boolean presentable) {
        if (presentable) {
            this.setModifiers(this.getModifiers() | 0x40000000L);
        } else {
            this.setModifiers(this.getModifiers() & 0xFFFFFFFFBFFFFFFFL);
        }
        this.setTransientProperty("generateStubs", "true");
        this.fireTypeChanged();
    }

    public boolean isPresentable() {
        return Modifier.isPresentable(this.getModifiers());
    }

    public XFormPresentationModel getPresentationModel(String name) {
        return this.presentations == null ? null : this.presentations.get(name);
    }

    public String[] getPresentationNames() {
        String names = this.getProperty(PRESENTATION_NAMES);
        return names != null ? Str.split(names, ',', false) : new String[]{};
    }

    public void setPresentations(Map<String, XFormPresentationModel> t) {
        this.presentations = t;
        this.updatePresentationNames();
    }

    public Map<String, XFormPresentationModel> getPresentations() {
        return this.presentations == null ? null : new HashMap<String, XFormPresentationModel>(this.presentations);
    }

    public String[] getPresentationsName() {
        if (this.presentations == null) {
            return new String[0];
        }
        Set<String> names = this.presentations.keySet();
        return names.toArray(new String[names.size()]);
    }

    public void setPresentationNames(String[] names) {
        String strNames = "";
        if (names != null && names.length > 0) {
            strNames = Str.join(names, ',');
        }
        this.setProperty(PRESENTATION_NAMES, strNames.length() > 0 ? strNames : null);
    }

    @Override
    public void addMember(MethodTypeDescription member) {
        if (this.getName().equals(member.getName())) {
            for (MethodTypeDescription current = member; current != null; current = current.getNextMethod()) {
                current.setResultType(this);
                current.setVisible(true);
                current.setModifiers(current.getModifiers() | 0x40L);
            }
        }
        if (member.isTransformation()) {
            for (MethodTypeDescription transfMethod : ((TransformTypeDescription)member).toMethodTypeDescription()) {
                super.addMember(transfMethod);
            }
        } else {
            super.addMember(member);
        }
    }

    public String[] getAllGroupNames() {
        MethodTypeDescription[] attribs;
        ArrayList<String> list = new ArrayList<String>();
        for (MethodTypeDescription attrib : attribs = this.getMembers(18, 0L, 0x2000000L)) {
            if (!XObjectTypeDescription.isGroupAttribute(attrib.asAttribute())) continue;
            list.add(attrib.getName());
        }
        return list.toArray(new String[list.size()]);
    }

    public String[] getAllGroupedAttributeNames(String att) {
        AttributeTypeDescription groupAtt = this.getMember(this.getMemberIndex(att, 18)).asAttribute();
        if (groupAtt != null && XObjectTypeDescription.isGroupAttribute(groupAtt)) {
            MethodTypeDescription[] attribs;
            ObjectTypeDescription innerGroup = (ObjectTypeDescription)groupAtt.getResultType().getElementType();
            ArrayList<String> list = new ArrayList<String>();
            for (MethodTypeDescription attrib : attribs = innerGroup.getMembers(18, 0L, 0x2000000L)) {
                list.add(attrib.getName());
            }
            return list.toArray(new String[list.size()]);
        }
        return new String[0];
    }

    @Override
    public String getSignature() {
        return this.getJavaSignature();
    }

    @Override
    public XObjectTypeDescription clone() {
        XObjectTypeDescription result = (XObjectTypeDescription)super.clone();
        for (int inn = 0; inn < this.getInnerTypeCount(); ++inn) {
            ObjectTypeDescription inner = this.getInnerType(inn);
            ObjectTypeDescription newInner = inner.clone();
            result.addInnerType(newInner);
        }
        if (this.presentations != null) {
            HashMap<String, XFormPresentationModel> presentations = new HashMap<String, XFormPresentationModel>();
            for (String key : this.presentations.keySet()) {
                XFormPresentationModel pres = this.presentations.get(key);
                presentations.put(key, pres.clone());
            }
            result.setPresentations(presentations);
        }
        return result;
    }

    public ObjectTypeDescription copy(String name) {
        XObjectTypeDescription result = this.clone();
        if (name != null) {
            result.setName(name);
        }
        result.setParent(null);
        XFormPresentationModel[] presentations = result.getPModels();
        if (presentations != null) {
            for (XFormPresentationModel presentation : presentations) {
                presentation.getPresentation().reference = name;
            }
        }
        Map<String, ObjectTypeDescription> replacements = XObjectTypeDescription.buildReplacementMap(new HashMap<String, ObjectTypeDescription>(), this, result);
        XObjectTypeDescription.replaceType(result, replacements, true);
        return result;
    }

    public ObjectTypeDescription copy() {
        return this.copy(null);
    }

    @Override
    public TypeDescription get() {
        return this;
    }

    @Override
    public Object newInstance() throws ComponentExecutionException {
        return null;
    }

    public void removePModel(String name) {
        if (this.presentations != null) {
            XFormPresentationModel removed = this.presentations.remove(name);
            this.updatePresentationNames();
            this.fireTypeChanged();
            this.fireRelationRemoved(PRESENTATION_PROPERTY, removed);
        }
    }

    @Override
    public boolean isSchemaObject() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public SchemaObject asSchemaObject() {
        SchemaObject schemaObject = SchemaObjectFactory.createForBpmObjectType(this);
        if (schemaObject == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/XObjectTypeDescription.asSchemaObject must not return null");
        }
        return schemaObject;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public ServiceObject asServiceObject() {
        ServiceObject serviceObject = ServiceObjectFactory.createForBpmObjectType(this);
        if (serviceObject == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/XObjectTypeDescription.asServiceObject must not return null");
        }
        return serviceObject;
    }

    public void validate() throws ObjectTypeDescriptionException {
        throw new UnsupportedOperationException("Validate is going to die, please use new XObjectCompilation Manager");
    }

    public Map<String, ResourceValue> getResources() {
        if (this.resources == null) {
            this.resources = new TreeMap<String, ResourceValue>();
        }
        return this.resources;
    }

    public String getResource(String key, Locale locale) {
        String resource;
        ResourceValue currentMap = this.getResources().get(key);
        if (currentMap != null) {
            LocaleStringMap map = currentMap.getLocaleMap();
            resource = map.getString(locale);
        } else {
            resource = null;
        }
        return resource;
    }

    public void setResource(String resourceKey, int type, String translatedResource, String localeString) {
        Locale locale = Locales.valueOf(localeString);
        Map<String, ResourceValue> resources = this.getResources();
        ResourceValue currentMap = resources.get(resourceKey);
        if (currentMap == null) {
            currentMap = new ResourceValue(type);
            resources.put(resourceKey, currentMap);
        }
        currentMap.localeMap.put(locale, translatedResource);
    }

    public void setResource(String resourceKey, int type, LocaleStringMap localeStringMap) {
        ResourceValue currentMap = this.getCurrentMap(resourceKey, type);
        currentMap.localeMap.putAll(localeStringMap);
    }

    @Override
    public void setRef(TypeRef ref) {
        super.setRef(ref);
        if (this.presentations != null) {
            XFormPresentationModel[] pModels;
            Collection<XFormPresentationModel> values = this.presentations.values();
            for (XFormPresentationModel pModel : pModels = values.toArray(new XFormPresentationModel[values.size()])) {
                pModel.setOwner(this);
            }
        }
    }

    @Override
    protected boolean isAssignableFromImpl(@NotNull TypeDescription source) {
        if (source == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/lang/XObjectTypeDescription.isAssignableFromImpl must not be null");
        }
        XmlTypeDescription xtd = TypeUtils.getModelObject(this);
        return xtd != null && xtd.isAssignableFromImpl(source);
    }

    static ObjectTypeDescription createObject() {
        return new XObjectTypeDescription();
    }

    private static Map<String, ObjectTypeDescription> buildReplacementMap(Map<String, ObjectTypeDescription> replacements, ObjectTypeDescription source, ObjectTypeDescription copy) {
        replacements.put(source.getText(), copy);
        int innerCount = source.getInnerTypeCount();
        assert (copy.getInnerTypeCount() == innerCount) : copy.getInnerTypeCount() + " != " + innerCount;
        for (int i = 0; i < innerCount; ++i) {
            ObjectTypeDescription innerType = copy.getInnerType(i);
            XObjectTypeDescription.buildReplacementMap(replacements, source.getInnerType(i), innerType);
        }
        return replacements;
    }

    private ResourceValue getCurrentMap(String resourceKey, int type) {
        Map<String, ResourceValue> resources = this.getResources();
        ResourceValue currentMap = resources.get(resourceKey);
        if (currentMap == null) {
            currentMap = new ResourceValue(type);
            if (resourceKey == null) {
                if (Log.isDebugging()) {
                    Log.logDebug(new IllegalArgumentException());
                }
            } else {
                resources.put(resourceKey, currentMap);
            }
        }
        return currentMap;
    }

    private void updatePresentationNames() {
        if (this.presentations == null) {
            this.setPresentationNames(new String[0]);
        } else {
            Set<String> set = this.presentations.keySet();
            this.setPresentationNames(set.toArray(new String[set.size()]));
        }
    }

    public static class ResourceValue
    implements Serializable {
        LocaleStringMap localeMap;
        int type;
        public static final long serialVersionUID = -2481154473843470830L;

        public ResourceValue(int type) {
            this.type = type;
            this.localeMap = LocaleStringMap.create();
        }

        public LocaleStringMap getLocaleMap() {
            return this.localeMap;
        }

        public int getType() {
            return this.type;
        }

        public ResourceValue copy() {
            ResourceValue result = new ResourceValue(this.type);
            result.localeMap = this.localeMap.clone();
            return result;
        }
    }
}

