/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Map;
import oracle.bpm.lang.Day;
import oracle.bpm.lang.DynamicObject;
import oracle.bpm.lang.WorkDaySchedule;

public class WorkWeek
implements Serializable {
    private WorkDaySchedule[] daySchedules = new WorkDaySchedule[Day.values().length];
    static final long serialVersionUID = 4243570442360312061L;
    public static Day[] dayOfWeek = new Day[]{Day.MONDAY, Day.TUESDAY, Day.WEDNESDAY, Day.THURSDAY, Day.FRIDAY, Day.SATURDAY, Day.SUNDAY};
    static final long serialCheck = 618512001143051719L;

    public static WorkWeek getDefault() {
        WorkWeek workWeek = new WorkWeek();
        for (Day day : Day.values()) {
            WorkDaySchedule daySchedule = new WorkDaySchedule();
            daySchedule.setShift(0, 800, 1200);
            daySchedule.setShift(1, 1300, 1700);
            workWeek.setSchedule(day, daySchedule);
        }
        return workWeek;
    }

    public static WorkWeek legacyValueOf(Map daySchedules) {
        WorkWeek result = new WorkWeek();
        for (Map.Entry entry : daySchedules.entrySet()) {
            int d = ((DynamicObject)entry.getKey()).intValue();
            DynamicObject workDay = (DynamicObject)entry.getValue();
            DynamicObject start1 = workDay.getField("start1") == DynamicObject.NULL ? workDay.getField("start1_d") : workDay.getField("start1");
            int s1 = start1.intValue();
            DynamicObject start2 = workDay.getField("start2") == DynamicObject.NULL ? workDay.getField("start2_d") : workDay.getField("start2");
            int s2 = start2.intValue();
            DynamicObject finish1 = workDay.getField("finish1") == DynamicObject.NULL ? workDay.getField("finish1_d") : workDay.getField("finish1");
            int f1 = finish1.intValue();
            DynamicObject finish2 = workDay.getField("finish2") == DynamicObject.NULL ? workDay.getField("finish2_d") : workDay.getField("finish2");
            int f2 = finish2.intValue();
            WorkDaySchedule schedule = new WorkDaySchedule();
            schedule.setShift(0, s1, f1);
            if (s2 != 2400) {
                schedule.setShift(1, s2, f2);
            }
            result.daySchedules[d] = schedule;
        }
        return result;
    }

    public static WorkWeek valueOf(String text) {
        WorkWeek result = new WorkWeek();
        for (int i = 0; i < dayOfWeek.length; ++i) {
            Day day = dayOfWeek[i];
            String dayStr = day.toString() + "=";
            int beg = text.indexOf(dayStr);
            if (beg == -1) continue;
            int end = text.indexOf(10, beg += dayStr.length());
            String wday = end == -1 ? text.substring(beg) : text.substring(beg, end);
            result.setSchedule(day, WorkDaySchedule.valueOf(wday));
        }
        return result;
    }

    public boolean equals(Object o) {
        return this == o || o instanceof WorkWeek && Arrays.equals(this.daySchedules, ((WorkWeek)o).daySchedules);
    }

    public WorkDaySchedule getSchedule(Day day) {
        return this.daySchedules[day.intValue()];
    }

    public int hashCode() {
        int result = 0;
        if (this.daySchedules != null) {
            for (int i = 0; i < this.daySchedules.length; ++i) {
                result *= 31;
                if (this.daySchedules[i] == null) continue;
                result += this.daySchedules[i].hashCode();
            }
        }
        return result;
    }

    public boolean isWorkingDay(Day day) {
        WorkDaySchedule schedule = this.getSchedule(day);
        return schedule != null && schedule.hasShift(0);
    }

    public boolean isWorkingDay(Calendar calendar) {
        return this.isWorkingDay(Day.valueOf(calendar));
    }

    public void setSchedule(Day day, WorkDaySchedule schedule) {
        this.daySchedules[day.intValue()] = schedule;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < Day.values().length; ++i) {
            if (this.daySchedules[i] == null) continue;
            if (buffer.length() > 0) {
                buffer.append('\n');
            }
            buffer.append(Day.values()[i].toString());
            buffer.append('=');
            buffer.append(this.daySchedules[i].toString());
        }
        return buffer.toString();
    }
}

