/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import oracle.bpm.lang.Id;

public class VersionNumber
implements Comparable {
    protected String version_d;

    public VersionNumber(String version) {
        this.version_d = version.equals(Id.getVersionTag()) ? "99999.0" : version;
    }

    public boolean isGreaterThan(VersionNumber versionNumber) {
        return this.compareTo(versionNumber) > 0;
    }

    public boolean isSmallerThan(VersionNumber versionNumber) {
        return this.compareTo(versionNumber) < 0;
    }

    public String getVersion() {
        return this.version_d;
    }

    public int compareTo(Object otherObject) {
        if (this.equals(otherObject)) {
            return 0;
        }
        StringTokenizer ownTokenizer = this.getTokenizer();
        StringTokenizer otherTokenizer = ((VersionNumber)otherObject).getTokenizer();
        while (ownTokenizer.hasMoreTokens()) {
            int otherNumber;
            int ownNumber;
            try {
                ownNumber = Integer.parseInt(ownTokenizer.nextToken());
                otherNumber = Integer.parseInt(otherTokenizer.nextToken());
            }
            catch (NoSuchElementException nseex) {
                return 1;
            }
            if (ownNumber > otherNumber) {
                return 1;
            }
            if (ownNumber >= otherNumber) continue;
            return -1;
        }
        otherTokenizer.nextToken();
        return -1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VersionNumber)) {
            return false;
        }
        VersionNumber versionNumber = (VersionNumber)o;
        return !(this.version_d != null ? !this.version_d.equals(versionNumber.version_d) : versionNumber.version_d != null);
    }

    public int hashCode() {
        return this.version_d != null ? this.version_d.hashCode() : 0;
    }

    protected StringTokenizer getTokenizer() {
        return new StringTokenizer(this.getVersion(), ".");
    }
}

