/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.TypeUtils;
import org.jetbrains.annotations.NonNls;

public final class SuperType {
    private final long modifiers;
    private TypeRef parent;
    private TypeRef type;
    public static final long VALID_MODIFIERS_MASK = 41976832L;

    public SuperType(TypeRef type, long modifiers) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        if ((modifiers & 0xFFFFFFFFFD7F7BFFL) != 0L) {
            throw new IllegalArgumentException("Invalid inheritance modifiers: '" + Modifier.getText(modifiers) + '\'');
        }
        this.type = type.getRef();
        this.modifiers = modifiers;
    }

    public static List<SuperType> getAnySuperTypeList() {
        return Arrays.asList(SuperType.getAny());
    }

    public static SuperType getAny() {
        return new SuperType(TypeFactory.getAny(), 32768L);
    }

    public static List<SuperType> forBool() {
        return BoolH.SUPERTYPES;
    }

    public static List<SuperType> forString() {
        return StringH.SUPERTYPES;
    }

    public static List<SuperType> forInt() {
        return IntegerH.SUPERTYPES;
    }

    public static List<SuperType> forReal() {
        return RealH.SUPERTYPES;
    }

    public static List<SuperType> forDecimal() {
        return DecimalH.SUPERTYPES;
    }

    public static List<SuperType> forBinary() {
        return BinaryH.SUPERTYPES;
    }

    public boolean isDelegated() {
        return Modifier.isDelegated(this.getModifiers());
    }

    public boolean isInterface() {
        return Modifier.isInterface(this.getModifiers());
    }

    public long getModifiers() {
        return this.modifiers;
    }

    public void setType(TypeRef type) {
        this.type = type != null ? type.getRef() : null;
    }

    public TypeDescription getType() {
        return this.type.get();
    }

    public ObjectTypeDescription getObjectType() {
        return this.getType().asObject();
    }

    public TypeRef getTypeRef() {
        return this.type;
    }

    public String getText() {
        return this.getTypeRef().getText();
    }

    public SuperType clone() {
        return new SuperType(this.type, this.modifiers);
    }

    @NonNls
    public String toString() {
        return "SuperType(" + this.type.getText() + ", " + Modifier.getText(this.modifiers) + ')';
    }

    public boolean isHidden() {
        return Modifier.isHidden(this.getModifiers());
    }

    public void setParent(TypeRef parent) {
        this.parent = parent.getRef();
    }

    public TypeRef getParent() {
        return this.parent;
    }

    static List<SuperType> buildSupertypes(String name) {
        return Collections.unmodifiableList(Arrays.asList(SuperType.getAny(), SuperType.createPublicDelegated(name)));
    }

    private static SuperType createPublicDelegated(@NonNls String name) {
        return new SuperType(TypeUtils.loadType(name), 0x808000L);
    }

    private static final class StringH {
        static final List<SuperType> SUPERTYPES = SuperType.buildSupertypes("Fuego.Internal.Str");

        private StringH() {
        }
    }

    private static final class RealH {
        static final List<SuperType> SUPERTYPES = SuperType.buildSupertypes("Fuego.Internal.Real");

        private RealH() {
        }
    }

    private static final class IntegerH {
        static final List<SuperType> SUPERTYPES = SuperType.buildSupertypes("Fuego.Internal.Int");

        private IntegerH() {
        }
    }

    private static final class DecimalH {
        static final List<SuperType> SUPERTYPES = SuperType.buildSupertypes("Fuego.Internal.Decimal");

        private DecimalH() {
        }
    }

    private static final class BoolH {
        static final List<SuperType> SUPERTYPES = SuperType.buildSupertypes("Fuego.Internal.Bool");

        private BoolH() {
        }
    }

    private static final class BinaryH {
        static final List<SuperType> SUPERTYPES = SuperType.buildSupertypes("Fuego.Internal.Binary");

        private BinaryH() {
        }
    }
}

