/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import oracle.bpm.lang.AbstractTypeUUID;
import org.jetbrains.annotations.NotNull;

public class PortTypeUUID
extends AbstractTypeUUID {
    protected static final char TYPE_PREFIX_ID = 'P';

    private PortTypeUUID(@NotNull String namespace, @NotNull String name) {
        if (namespace == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/lang/PortTypeUUID.<init> must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/lang/PortTypeUUID.<init> must not be null");
        }
        super(namespace, name);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String getId() {
        String string = this.getTypeId() + "|" + this.getNamespace() + "|" + this.getNativeName();
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/PortTypeUUID.getId must not return null");
        }
        return string;
    }

    @Override
    protected char getTypeId() {
        return 'P';
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    static PortTypeUUID parse(@NotNull String uuid) {
        if (uuid == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/lang/PortTypeUUID.parse must not be null");
        }
        String[] strings = uuid.split("\\|");
        if (strings.length != 3) {
            throw new IllegalArgumentException("Invalid port type id: '" + uuid + '\'');
        }
        if (!strings[0].equals(String.valueOf('P'))) {
            throw new IllegalArgumentException("Invalid port type id: '" + uuid + '\'');
        }
        String namespace = strings[1];
        String name = strings[2];
        PortTypeUUID portTypeUUID = new PortTypeUUID(namespace, name);
        if (portTypeUUID == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/PortTypeUUID.parse must not return null");
        }
        return portTypeUUID;
    }

    static PortTypeUUID create(@NotNull String namespace, @NotNull String name) {
        if (namespace == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/lang/PortTypeUUID.create must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/lang/PortTypeUUID.create must not be null");
        }
        return new PortTypeUUID(namespace, name);
    }
}

