/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.type.IdentifiableType;
import oracle.bpm.util.Identifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NamespacedTypeDescription
extends ObjectTypeDescription
implements IdentifiableType {
    protected NamespacedTypeDescription(@NotNull String name, @NotNull String namespace, @Nullable String location) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/lang/NamespacedTypeDescription.<init> must not be null");
        }
        if (namespace == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/lang/NamespacedTypeDescription.<init> must not be null");
        }
        this(name, namespace, location, 11);
    }

    protected NamespacedTypeDescription(@NotNull String name, @NotNull String namespace, @Nullable String location, int kind) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/lang/NamespacedTypeDescription.<init> must not be null");
        }
        if (namespace == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/lang/NamespacedTypeDescription.<init> must not be null");
        }
        super(Identifier.classname(name), kind, false);
        this.setNamespace(namespace);
        this.setName(Identifier.classname(name));
        this.setNativeName(name);
        this.setLocalEnabled(true);
        this.setModifiers(this.getModifiers() | 0x10000000L);
        if (location != null) {
            this.setLocation(location);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getLocation() {
        Object transientProperty = this.getTransientProperty("resource_location");
        if (transientProperty == null) {
            throw new IllegalStateException("Transient property 'resource_location' is null");
        }
        String string = (String)transientProperty;
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/NamespacedTypeDescription.getLocation must not return null");
        }
        return string;
    }

    public void setLocation(@NotNull String location) {
        if (location == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/lang/NamespacedTypeDescription.setLocation must not be null");
        }
        this.setTransientProperty("resource_location", location);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getNamespace() {
        String string = this.getProperty("namespace");
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/NamespacedTypeDescription.getNamespace must not return null");
        }
        return string;
    }

    @Override
    public boolean equals(Object type) {
        if (this == type) {
            return true;
        }
        if (!(type instanceof NamespacedTypeDescription)) {
            return false;
        }
        NamespacedTypeDescription that = (NamespacedTypeDescription)type;
        return this.getId().equals(that.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    private void setNamespace(@NotNull String namespace) {
        if (namespace == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/lang/NamespacedTypeDescription.setNamespace must not be null");
        }
        this.setProperty("namespace", namespace);
    }
}

