/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import oracle.bpm.collections.Predicate;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.lang.JavaClass;
import oracle.bpm.msg.CoreMsg;

public class JavaClassScanner {
    private static final int DOT_CLASS_LENGTH = ".class".length();

    public static String[] scan(File[] classPath, String[] selection) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < classPath.length; ++i) {
            if (!classPath[i].exists()) {
                throw new IOException(CoreMsg.FILE_NOT_FOUND(classPath[i].getAbsolutePath()).toString());
            }
            JavaClassScanner.scan(classPath[i], selection, result);
        }
        Collections.sort(result);
        return result.toArray(new String[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scanJarFile(JarFile jarFile, Predicate<String> filter, Collection<String> classes, boolean escapeInner) throws IOException {
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            DataInputStream jarInputStream;
            block4: {
                String clName;
                JarEntry entry = entries.nextElement();
                if (entry.isDirectory() || JavaClassScanner.isBeanInfo(clName = entry.getName()) || !JavaClassScanner.isClassName(clName) || JavaClassScanner.isAnonymousClassName(clName)) continue;
                clName = clName.replace('/', '.');
                if (escapeInner) {
                    clName = clName.replace('$', '.');
                }
                if (!filter.check(clName = clName.substring(0, clName.length() - DOT_CLASS_LENGTH))) continue;
                jarInputStream = null;
                try {
                    jarInputStream = new DataInputStream(jarFile.getInputStream(entry));
                    boolean isPublic = JavaClass.isPublic(jarInputStream);
                    if (!isPublic) break block4;
                    classes.add(clName);
                }
                catch (Throwable throwable) {
                    StreamUtils.close(jarInputStream);
                    throw throwable;
                }
            }
            StreamUtils.close(jarInputStream);
        }
    }

    static List<String> scan(File path, String[] selection, List<String> classes) throws IOException {
        if (path.isDirectory()) {
            JavaClassScanner.scanDir(path, selection, null, classes);
        } else {
            JavaClassScanner.scanJar(path, selection, classes);
        }
        return classes;
    }

    static String[] filterClasses(String[] sources, String[] selections) {
        ArrayList<String> classes = new ArrayList<String>();
        for (int i = 0; i < sources.length; ++i) {
            String source = sources[i];
            if (!JavaClassScanner.isSelected(source, selections)) continue;
            classes.add(source);
        }
        Collections.sort(classes);
        return classes.toArray(new String[classes.size()]);
    }

    private static boolean isAnonymousClassName(String clName) {
        int index = clName.lastIndexOf("$");
        if (index >= 0) {
            return ++index < clName.length() && !Character.isLetter(clName.charAt(index));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> scanDir(File path, String[] selection, String currentPkg, List<String> classes) throws IOException {
        File[] files = path.listFiles();
        for (int i = 0; i < files.length; ++i) {
            DataInputStream jarInputStream;
            block4: {
                File file = files[i];
                String name = file.getName();
                if (file.isDirectory()) {
                    JavaClassScanner.scanDir(file, selection, currentPkg != null ? currentPkg + "." + name : name, classes);
                    continue;
                }
                String clName = currentPkg + "." + name;
                if (JavaClassScanner.isBeanInfo(clName) || !JavaClassScanner.isClassName(clName)) continue;
                clName = clName.replace(File.separatorChar, '.');
                if (!JavaClassScanner.isSelected(clName = clName.substring(0, clName.length() - 6), selection)) continue;
                jarInputStream = null;
                try {
                    jarInputStream = new DataInputStream(new FileInputStream(file));
                    boolean isPublic = JavaClass.isPublic(jarInputStream);
                    if (!isPublic) break block4;
                    classes.add(clName.intern());
                }
                catch (Throwable throwable) {
                    StreamUtils.close(jarInputStream);
                    throw throwable;
                }
            }
            StreamUtils.close(jarInputStream);
        }
        return classes;
    }

    private static List<String> scanJar(File path, String[] selection, List<String> classes) throws IOException {
        JarFile jarFile = new JarFile(path);
        JavaClassScanner.scanJarFile(jarFile, new SelectionPredicate(selection), classes, false);
        jarFile.close();
        return classes;
    }

    private static boolean isBeanInfo(String name) {
        return name.lastIndexOf("BeanInfo.") != -1;
    }

    private static boolean isClassName(String name) {
        return name.endsWith(".class");
    }

    private static boolean isSelected(String clName, String[] selections) {
        boolean selected = true;
        if (selections != null) {
            selected = false;
            for (String selection : selections) {
                if (!clName.startsWith(selection + ".") && !clName.equals(selection)) continue;
                selected = true;
                break;
            }
        }
        return selected;
    }

    private static class SelectionPredicate
    implements Predicate<String> {
        private String[] selection;

        public SelectionPredicate(String[] selection) {
            this.selection = selection;
        }

        @Override
        public boolean check(String value) {
            return JavaClassScanner.isSelected(value, this.selection);
        }
    }
}

