/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import java.util.Iterator;
import oracle.bpm.lang.CollectionTypeDescription;
import oracle.bpm.lang.IllegalTypeException;
import oracle.bpm.lang.Initialization;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeRef;

public class IteratorTypeDescription
extends CollectionTypeDescription {
    public static final TypeDescription ANY_ITERATOR = new IteratorTypeDescription(TypeFactory.getAny());

    public IteratorTypeDescription(TypeRef elemType) {
        this(elemType, "java.util.Iterator");
    }

    public IteratorTypeDescription(TypeRef elemType, String javaType) {
        super(16, javaType);
        this.elementType = elemType;
        this.loadMembers();
    }

    private IteratorTypeDescription(String elemText, ComponentCatalog catalog) throws IllegalTypeException {
        super(16, "java.util.Iterator");
        assert (elemText != null) : "Element text is null";
        this.elementText = elemText;
        this.catalog = catalog;
        this.loadMembers();
    }

    public static IteratorTypeDescription createLazyIterator(String elemText, ComponentCatalog catalog) throws IllegalTypeException {
        return new IteratorTypeDescription(elemText, catalog);
    }

    @Override
    public Initialization getInitialization() {
        return Initialization.NULL;
    }

    @Override
    public boolean isIterator() {
        return true;
    }

    @Override
    public Class getJavaClass() {
        return Iterator.class;
    }

    @Override
    public Object invokeMethod(String methodSignature, Object target, Object[] args) {
        Iterator it = (Iterator)target;
        if ("Mremove()V".equals(methodSignature)) {
            it.remove();
            return null;
        }
        throw new RuntimeException("No such method: " + methodSignature);
    }

    @Override
    protected boolean isAssignableFromImpl(TypeDescription b) {
        return (b.getKind() == 12 || b.getKind() == 13 || b.getKind() == 16) && this.getElementType().isAssignableFrom(b.getElementType());
    }

    @Override
    protected void loadMembers() {
        MethodTypeDescription mtd = new MethodTypeDescription("delete");
        mtd.setSignature("Mremove()V");
        this.addMember(mtd);
    }
}

