/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import java.util.Map;
import java.util.TreeMap;
import oracle.bpm.lang.ComponentType;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.PortTypeUUID;
import oracle.bpm.lang.UUIDFactory;
import oracle.bpm.lang.WsdlTypeDescription;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.DynamicRef;
import oracle.bpm.type.TypeRef;
import oracle.bpm.util.Identifier;
import org.jetbrains.annotations.NotNull;

public class DelegatedMethodTypeDescription
extends MethodTypeDescription {
    private String delegatedMethodSignature;
    private PortTypeUUID delegatedPortTypeId;
    private TypeRef delegatedServiceRef;
    private Map<String, Object> transientProperties;

    public DelegatedMethodTypeDescription(@NotNull String name, @NotNull WsdlTypeDescription delegatedPortType, @NotNull String delegatedMethodSignature) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/lang/DelegatedMethodTypeDescription.<init> must not be null");
        }
        if (delegatedPortType == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/lang/DelegatedMethodTypeDescription.<init> must not be null");
        }
        if (delegatedMethodSignature == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/lang/DelegatedMethodTypeDescription.<init> must not be null");
        }
        this(name, UUIDFactory.parsePortTypeId(delegatedPortType.getId()), delegatedMethodSignature, delegatedPortType.getName(), delegatedPortType.getCatalog());
    }

    public DelegatedMethodTypeDescription(@NotNull String name, @NotNull PortTypeUUID delegatedPortTypeId, @NotNull String delegatedMethodSignature, @NotNull ComponentCatalog catalog) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/lang/DelegatedMethodTypeDescription.<init> must not be null");
        }
        if (delegatedPortTypeId == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/lang/DelegatedMethodTypeDescription.<init> must not be null");
        }
        if (delegatedMethodSignature == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/lang/DelegatedMethodTypeDescription.<init> must not be null");
        }
        if (catalog == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/lang/DelegatedMethodTypeDescription.<init> must not be null");
        }
        this(name, delegatedPortTypeId, delegatedMethodSignature, Identifier.classname(delegatedPortTypeId.getNativeName()), catalog);
    }

    private DelegatedMethodTypeDescription(@NotNull String name, @NotNull PortTypeUUID delegatedPortTypeId, @NotNull String delegatedMethodSignature, @NotNull String delegatedServiceName, @NotNull ComponentCatalog catalog) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/lang/DelegatedMethodTypeDescription.<init> must not be null");
        }
        if (delegatedPortTypeId == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/lang/DelegatedMethodTypeDescription.<init> must not be null");
        }
        if (delegatedMethodSignature == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/lang/DelegatedMethodTypeDescription.<init> must not be null");
        }
        if (delegatedServiceName == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/lang/DelegatedMethodTypeDescription.<init> must not be null");
        }
        if (catalog == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of oracle/bpm/lang/DelegatedMethodTypeDescription.<init> must not be null");
        }
        super(name);
        this.delegatedMethodSignature = delegatedMethodSignature;
        this.delegatedPortTypeId = delegatedPortTypeId;
        this.delegatedServiceRef = new DynamicRef(ComponentType.PORT_TYPE.getText(), delegatedPortTypeId.getId(), delegatedServiceName, catalog);
        this.setModifiers(64L);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getDelegatedMethodSignature() {
        String string = this.delegatedMethodSignature;
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/DelegatedMethodTypeDescription.getDelegatedMethodSignature must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public TypeRef getDelegatedServiceRef() {
        TypeRef typeRef = this.delegatedServiceRef;
        if (typeRef == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/DelegatedMethodTypeDescription.getDelegatedServiceRef must not return null");
        }
        return typeRef;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getDelegatedPortTypeNamespace() {
        String string = this.delegatedPortTypeId.getNamespace();
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/DelegatedMethodTypeDescription.getDelegatedPortTypeNamespace must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getDelegatedPortTypeName() {
        String string = this.delegatedPortTypeId.getNativeName();
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/DelegatedMethodTypeDescription.getDelegatedPortTypeName must not return null");
        }
        return string;
    }

    @Override
    public boolean isDelegated() {
        return true;
    }

    @Override
    public DelegatedMethodTypeDescription asDelegated() {
        return this;
    }

    @Override
    public Object getTransientProperty(String key) {
        return this.getTransientProperties().get(key);
    }

    @Override
    public void setTransientProperty(String key, Object value) {
        this.getTransientProperties().put(key, value);
    }

    @Override
    public Map<String, Object> getTransientProperties() {
        if (this.transientProperties == null) {
            this.transientProperties = new TreeMap<String, Object>();
        }
        return this.transientProperties;
    }
}

