/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import oracle.bpm.lang.ArrayTypeDescription;
import oracle.bpm.lang.IllegalTypeException;
import oracle.bpm.lang.Initialization;
import oracle.bpm.lang.IteratorTypeDescription;
import oracle.bpm.lang.Kind;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.SetTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.log.Log;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeRef;
import org.jetbrains.annotations.NotNull;

public class CollectionTypeDescription
extends ObjectTypeDescription {
    protected ComponentCatalog catalog;
    protected String elementText;
    protected TypeRef elementType;
    protected String indexText;
    protected TypeRef indexType;
    protected boolean isOrdered;
    protected String javaType;

    protected CollectionTypeDescription(int kind) {
        this(kind, null);
    }

    protected CollectionTypeDescription(int kind, String javaType) {
        super("", kind, false);
        this.javaType = javaType;
    }

    @Override
    public boolean isCloneable() {
        return this.getKind() != 16;
    }

    @Override
    public void setElementType(TypeRef el) {
        this.elementType = el;
        this.elementText = null;
    }

    @Override
    public TypeDescription getElementType() {
        TypeRef ref = this.getElementTypeRef();
        return ref != null ? ref.get() : null;
    }

    @Override
    public TypeRef getElementTypeRef() {
        if (this.elementText != null) {
            try {
                TypeRef elementRef = TypeFactory.forNameLazy(this.elementText, this.catalog, this.getElementJavaType(this.javaType));
                this.setElementType(elementRef);
            }
            catch (IllegalTypeException e) {
                this.elementType = TypeFactory.getNone();
                Log.logWarning(e);
            }
            this.elementText = null;
        }
        TypeRef result = this.elementType;
        if (!this.isPrimitive() && this.elementType.get().isPrimitive()) {
            this.elementType = result = result.get().primitiveEquivalent(false);
        }
        return result;
    }

    public void setIndexType(TypeRef ixType) {
        this.indexType = ixType;
        this.indexText = null;
    }

    @Override
    public TypeDescription getIndexType() {
        TypeRef ref = this.getIndexTypeRef();
        return ref != null ? ref.get() : null;
    }

    @Override
    public TypeRef getIndexTypeRef() {
        TypeDescription result;
        if (this.indexText != null) {
            try {
                this.setIndexType(TypeFactory.forNameLazy(this.indexText, this.catalog));
            }
            catch (IllegalTypeException e) {
                this.indexType = TypeFactory.getNone();
                Log.logWarning(e);
            }
            this.indexText = null;
        }
        TypeDescription typeDescription = result = this.indexType != null ? this.indexType.get() : null;
        if (!this.isPrimitive() && this.indexType != null && CollectionTypeDescription.isPrimitive(this.indexType)) {
            result = result.get().primitiveEquivalent(false);
            this.indexType = result;
        }
        return result;
    }

    @Override
    public Initialization getInitialization() {
        return Initialization.DEFAULT_CONSTRUCTOR;
    }

    @Override
    public boolean isIterable() {
        return true;
    }

    @Override
    public String getJavaType() {
        return this.javaType;
    }

    @Override
    public boolean isOrdered() {
        return this.isOrdered;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String getText() {
        String string = Kind.getName(this.getKind()) + "(" + this.getElementType().getText() + (this.getIndexType() != null ? ", " + this.getIndexType().getText() : "") + ")";
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/CollectionTypeDescription.getText must not return null");
        }
        return string;
    }

    @Override
    public boolean equality(TypeDescription other) {
        return other.getKind() == 9 || this.getKind() != 16 && this.getKind() == other.getKind() && this.getElementType().equality(other.getElementType()) && (this.getIndexType() == null || this.getIndexType().equality(other.getIndexType()));
    }

    @Override
    public boolean equals(Object value) {
        if (this == value) {
            return true;
        }
        if (value == null) {
            return false;
        }
        if (!(value instanceof CollectionTypeDescription)) {
            return false;
        }
        CollectionTypeDescription type = (CollectionTypeDescription)value;
        return this.getKind() == type.getKind() && this.getElementType().equals(type.getElementType()) && (this.getIndexType() == null || this.getIndexType().equals(type.getIndexType())) && this.isOrdered == type.isOrdered() && this.isPrimitive() == type.isPrimitive();
    }

    @Override
    public boolean equivalent(TypeDescription other) {
        return this.getKind() == other.getKind() && this.getElementType().equivalent(other.getElementType()) && (this.getIndexType() == null || this.getIndexType().equivalent(other.getIndexType())) && this.isOrdered == other.isOrdered() && this.isPrimitive() == other.isPrimitive();
    }

    @Override
    public boolean hasDefaultInit() {
        return true;
    }

    @Override
    public TypeDescription primitiveEquivalent(boolean prim) {
        return this;
    }

    @Override
    public TypeDescription promoteImpl(TypeDescription other) {
        if (other.getKind() != this.getKind()) {
            return TypeFactory.getAny();
        }
        if (other == this || other.equals(this)) {
            return this;
        }
        TypeDescription net = null;
        if (!this.getElementType().equals(other.getElementType())) {
            net = this.getElementType().promote(other.getElementType());
        }
        TypeDescription nit = null;
        if (this.getIndexType() != null && !this.getIndexType().equals(other.getIndexType())) {
            nit = this.getIndexType().promote(other.getIndexType());
        }
        if (net == null && nit == null) {
            return this.isOrdered() ? other : this;
        }
        CollectionTypeDescription promotion = null;
        switch (this.getKind()) {
            case 12: {
                promotion = new ArrayTypeDescription((TypeRef)net, null, this.isOrdered() && other.isOrdered());
                break;
            }
            case 19: {
                promotion = new SetTypeDescription((TypeRef)net, this.isOrdered() && other.isOrdered());
                break;
            }
            case 13: {
                nit = nit == null ? this.getIndexType() : nit;
                net = net == null ? this.getElementType() : net;
                promotion = new ArrayTypeDescription((TypeRef)net, (TypeRef)nit, this.isOrdered() && other.isOrdered());
                break;
            }
            case 16: {
                promotion = new IteratorTypeDescription(net);
            }
        }
        return promotion;
    }

    @Override
    public String toString() {
        return (this.isPrimitive() ? "p" : "") + Kind.getName(this.getKind()) + "(" + this.getElementType() + (this.getIndexType() != null ? ", " + this.getIndexType() : "") + ")";
    }

    @Override
    protected boolean isAssignableFromImpl(TypeDescription other) {
        return this.getKind() == other.getKind() && this.getElementType().isAssignableFrom(other.getElementType()) && (this.getIndexType() == null || this.getIndexType().isAssignableFrom(other.getIndexType()));
    }

    protected String getElementJavaType(String jtype) {
        return null;
    }

    @Override
    protected boolean isStrictSubtypeImpl(TypeDescription type) {
        return this.getKind() == type.getKind() && this.isPrimitive() == type.isPrimitive() && this.isOrdered() == type.isOrdered() && this.getElementType().isStrictSubtype(type.getElementType()) && (this.getIndexType() == null || this.getIndexType().isStrictSubtype(type.getIndexType()));
    }

    private static boolean isPrimitive(TypeRef type) {
        return type instanceof TypeDescription && type.get().isPrimitive();
    }
}

