/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.Argument;
import oracle.bpm.type.MutableComponentCatalog;
import oracle.bpm.type.TypeFinder;
import oracle.bpm.type.TypeInfo;
import oracle.bpm.type.TypeRef;
import oracle.bpm.util.ResourceUtils;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.EmptyVisitor;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.classfile.Visitor;
import org.apache.bcel.generic.Type;

final class BytecodeIntrospector
extends EmptyVisitor {
    private MethodTypeDescription lastMethod;
    private ObjectTypeDescription type;

    BytecodeIntrospector() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void introspect(Class cl, ObjectTypeDescription type) throws IOException {
        URL url = ResourceUtils.getClassURL(cl);
        if (url == null) {
            return;
        }
        InputStream in = null;
        try {
            in = url.openStream();
            ClassParser parser = new ClassParser(in, cl.getName());
            JavaClass javaClass = parser.parse();
            this.introspect(javaClass, type);
        }
        catch (Throwable throwable) {
            StreamUtils.close(in);
            throw throwable;
        }
        StreamUtils.close(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void introspect(JavaClass cl, ObjectTypeDescription type) throws IOException {
        try {
            this.type = type;
            cl.accept((Visitor)this);
        }
        finally {
            this.type = null;
            this.lastMethod = null;
        }
    }

    public void visitJavaClass(JavaClass javaClass) {
        Method[] methods;
        for (Method method : methods = javaClass.getMethods()) {
            method.accept((Visitor)this);
        }
    }

    public void visitMethod(Method method) {
        LocalVariableTable variableTable;
        this.lastMethod = null;
        MethodTypeDescription member = method.getName().equals("<init>") ? this.type.findMember(this.type.getName()) : this.type.findMethod(method.getName(), TypeFinder.Scope.CURRENT);
        if (member != null) {
            Type[] argTypes = method.getArgumentTypes();
            while (member != null) {
                if (member.getArgumentCount() == argTypes.length) {
                    boolean matchAll = true;
                    for (int i = 0; i < argTypes.length; ++i) {
                        Argument argument;
                        String javaType;
                        String signature = argTypes[i].getSignature().replace('/', '.');
                        if (signature.equals(javaType = this.getJavaSignature((argument = member.getArgument(i)).getTypeRef()))) continue;
                        matchAll = false;
                    }
                    if (matchAll) {
                        this.lastMethod = member;
                        break;
                    }
                }
                member = member.getNextMethod();
            }
        }
        if ((variableTable = method.getLocalVariableTable()) != null) {
            variableTable.accept((Visitor)this);
        }
    }

    public void visitLocalVariableTable(LocalVariableTable table) {
        if (this.lastMethod != null) {
            int doubleArguments = 0;
            for (LocalVariable variable : table.getLocalVariableTable()) {
                String name = variable.getName();
                if (name == null) continue;
                int index = variable.getIndex();
                int argIndex = this.lastMethod.isStatic() && !this.lastMethod.isConstructor() ? index : index - 1;
                if ((argIndex -= doubleArguments) < 0 || argIndex >= this.lastMethod.getArgumentCount()) continue;
                Argument arg = this.lastMethod.getArgument(argIndex);
                if (arg.getProperty("hasMetadataAnnotations") != null) {
                    arg.getProperties().remove("hasMetadataAnnotations");
                    continue;
                }
                arg.setName(name);
                String argumentType = Utility.signatureToString((String)variable.getSignature(), (boolean)true);
                if (!"double".equals(argumentType) && !"long".equals(argumentType)) continue;
                ++doubleArguments;
            }
        }
    }

    private String getJavaSignature(TypeRef typeRef) {
        String signature;
        if (typeRef instanceof TypeDescription) {
            signature = typeRef.get().getJavaSignature();
        } else {
            MutableComponentCatalog catalog = (MutableComponentCatalog)typeRef.getCatalog();
            TypeInfo info = catalog.getInfo(typeRef);
            signature = 'L' + info.getId() + ';';
        }
        return signature;
    }
}

