/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.jndi;

import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.event.EventDirContext;
import javax.naming.event.NamingListener;
import oracle.bpm.jndi.FaultTolerantDirContext;
import oracle.bpm.lib.msg.LibMsg;

public class FaultTolerantEventDirContext
extends FaultTolerantDirContext
implements EventDirContext {
    public FaultTolerantEventDirContext(DirContext ctx) throws NamingException {
        super(ctx, null);
    }

    @Override
    public void addNamingListener(Name target, int scope, NamingListener l) throws NamingException {
        NamingException originalException = null;
        for (int i = 0; i < FaultTolerantEventDirContext.getRetryTimes(); ++i) {
            try {
                this.getEventDirContext().addNamingListener(target, scope, l);
                return;
            }
            catch (NamingException ex) {
                originalException = originalException == null ? ex : originalException;
                this.handleExceptions(ex, i);
                continue;
            }
        }
        throw originalException;
    }

    @Override
    public void addNamingListener(String target, int scope, NamingListener l) throws NamingException {
        NamingException originalException = null;
        for (int i = 0; i < FaultTolerantEventDirContext.getRetryTimes(); ++i) {
            try {
                this.getEventDirContext().addNamingListener(target, scope, l);
                return;
            }
            catch (NamingException ex) {
                originalException = originalException == null ? ex : originalException;
                this.handleExceptions(ex, i);
                continue;
            }
        }
        throw originalException;
    }

    @Override
    public void removeNamingListener(NamingListener l) throws NamingException {
        NamingException originalException = null;
        for (int i = 0; i < FaultTolerantEventDirContext.getRetryTimes(); ++i) {
            try {
                this.getEventDirContext().removeNamingListener(l);
                return;
            }
            catch (NamingException ex) {
                originalException = originalException == null ? ex : originalException;
                this.handleExceptions(ex, i);
                continue;
            }
        }
        throw originalException;
    }

    @Override
    public final boolean targetMustExist() throws NamingException {
        NamingException originalException = null;
        for (int i = 0; i < FaultTolerantEventDirContext.getRetryTimes(); ++i) {
            try {
                return this.getEventDirContext().targetMustExist();
            }
            catch (NamingException ex) {
                originalException = originalException == null ? ex : originalException;
                this.handleExceptions(ex, i);
                continue;
            }
        }
        throw originalException;
    }

    @Override
    public void addNamingListener(Name target, String filter, Object[] filterArgs, SearchControls ctls, NamingListener l) throws NamingException {
        NamingException originalException = null;
        for (int i = 0; i < FaultTolerantEventDirContext.getRetryTimes(); ++i) {
            try {
                this.getEventDirContext().addNamingListener(target, filter, filterArgs, ctls, l);
                return;
            }
            catch (NamingException ex) {
                originalException = originalException == null ? ex : originalException;
                this.handleExceptions(ex, i);
                continue;
            }
        }
        throw originalException;
    }

    @Override
    public void addNamingListener(Name target, String filter, SearchControls ctls, NamingListener l) throws NamingException {
        NamingException originalException = null;
        for (int i = 0; i < FaultTolerantEventDirContext.getRetryTimes(); ++i) {
            try {
                this.getEventDirContext().addNamingListener(target, filter, ctls, l);
                return;
            }
            catch (NamingException ex) {
                originalException = originalException == null ? ex : originalException;
                this.handleExceptions(ex, i);
                continue;
            }
        }
        throw originalException;
    }

    @Override
    public void addNamingListener(String target, String filter, Object[] filterArgs, SearchControls ctls, NamingListener l) throws NamingException {
        NamingException originalException = null;
        for (int i = 0; i < FaultTolerantEventDirContext.getRetryTimes(); ++i) {
            try {
                this.getEventDirContext().addNamingListener(target, filter, filterArgs, ctls, l);
                return;
            }
            catch (NamingException ex) {
                originalException = originalException == null ? ex : originalException;
                this.handleExceptions(ex, i);
                continue;
            }
        }
        throw originalException;
    }

    @Override
    public void addNamingListener(String target, String filter, SearchControls ctls, NamingListener l) throws NamingException {
        NamingException originalException = null;
        for (int i = 0; i < FaultTolerantEventDirContext.getRetryTimes(); ++i) {
            try {
                this.getEventDirContext().addNamingListener(target, filter, ctls, l);
                return;
            }
            catch (NamingException ex) {
                originalException = originalException == null ? ex : originalException;
                this.handleExceptions(ex, i);
                continue;
            }
        }
        throw originalException;
    }

    @Override
    protected void reOpenContext(int attempt) throws NamingException {
        LibMsg.RECONNECTING(attempt).logInfo();
        if (this.context_d != null) {
            this.context_d.close();
            this.context_d = null;
        }
        this.context_d = new InitialDirContext(this.properties_d);
    }

    private EventDirContext getEventDirContext() {
        assert (this.context_d != null) : "Trying to get event dir context when it is already closed";
        return (EventDirContext)this.context_d;
    }
}

