/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.jndi;

import java.rmi.ConnectIOException;
import java.rmi.ServerException;
import java.util.Hashtable;
import javax.naming.CommunicationException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.ServiceUnavailableException;
import javax.naming.directory.InvalidSearchFilterException;
import oracle.bpm.connector.spi.ConnectorInterface;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.log.Log;
import oracle.bpm.util.Utilities;

public class FaultTolerantContext
implements Context {
    protected boolean autoReopen_d = false;
    protected ConnectorInterface connector;
    protected Context context_d;
    protected Hashtable properties_d;
    private boolean cached = true;
    public static final int MAX_RETRY_TIMES = 10;
    public static final int MAX_RETRY_DEFAULT = 3;
    public static final int ELAPSE_TIME = 1000;
    protected static int retryTimes_sd = 3;

    public FaultTolerantContext(Context ctx, ConnectorInterface connector) throws NamingException {
        this.context_d = ctx;
        this.properties_d = ctx.getEnvironment();
        this.connector = connector;
    }

    public FaultTolerantContext(Hashtable env, ConnectorInterface connector) throws NamingException {
        this.properties_d = env;
        this.context_d = this.createContext();
        this.connector = connector;
    }

    public static int getConnectionRetries() {
        return retryTimes_sd;
    }

    public static void setRetryTimes(int retryTimes) {
        if (retryTimes > 10) {
            retryTimes = 10;
        }
        retryTimes_sd = retryTimes;
    }

    public static int getRetryTimes() {
        return retryTimes_sd;
    }

    public final Hashtable getEnvironment() throws NamingException {
        NamingException originalException = null;
        for (int i = 0; i < FaultTolerantContext.getRetryTimes(); ++i) {
            try {
                return this.getContext().getEnvironment();
            }
            catch (NamingException ex) {
                originalException = originalException == null ? ex : originalException;
                this.handleExceptions(ex, i);
                continue;
            }
        }
        throw originalException;
    }

    @Override
    public void close() throws NamingException {
        if (!this.isCached() && this.context_d != null) {
            this.context_d.close();
        }
    }

    @Override
    public final String getNameInNamespace() throws NamingException {
        NamingException originalException = null;
        for (int i = 0; i < FaultTolerantContext.getRetryTimes(); ++i) {
            try {
                return this.getContext().getNameInNamespace();
            }
            catch (NamingException ex) {
                originalException = originalException == null ? ex : originalException;
                this.handleExceptions(ex, i);
                continue;
            }
        }
        throw originalException;
    }

    @Override
    public final NameParser getNameParser(Name name) throws NamingException {
        NamingException originalException = null;
        for (int i = 0; i < FaultTolerantContext.getRetryTimes(); ++i) {
            try {
                return this.getContext().getNameParser(name);
            }
            catch (NamingException ex) {
                originalException = originalException == null ? ex : originalException;
                this.handleExceptions(ex, i);
                continue;
            }
        }
        throw originalException;
    }

    @Override
    public final NameParser getNameParser(String name) throws NamingException {
        NamingException originalException = null;
        for (int i = 0; i < FaultTolerantContext.getRetryTimes(); ++i) {
            try {
                return this.getContext().getNameParser(name);
            }
            catch (NamingException ex) {
                originalException = originalException == null ? ex : originalException;
                this.handleExceptions(ex, i);
                continue;
            }
        }
        throw originalException;
    }

    @Override
    public final Object addToEnvironment(String s, Object obj) throws NamingException {
        NamingException originalException = null;
        for (int i = 0; i < FaultTolerantContext.getRetryTimes(); ++i) {
            try {
                return this.getContext().addToEnvironment(s, obj);
            }
            catch (NamingException ex) {
                originalException = originalException == null ? ex : originalException;
                this.handleExceptions(ex, i);
                continue;
            }
        }
        throw originalException;
    }

    @Override
    public final void bind(Name name, Object obj) throws NamingException {
        NamingException originalException = null;
        for (int i = 0; i < FaultTolerantContext.getRetryTimes(); ++i) {
            try {
                this.getContext().bind(name, obj);
                return;
            }
            catch (NamingException ex) {
                originalException = originalException == null ? ex : originalException;
                this.handleExceptions(ex, i);
                continue;
            }
        }
        throw originalException;
    }

    @Override
    public final void bind(String name, Object obj) throws NamingException {
        NamingException originalException = null;
        for (int i = 0; i < FaultTolerantContext.getRetryTimes(); ++i) {
            try {
                this.getContext().bind(name, obj);
                return;
            }
            catch (NamingException ex) {
                originalException = originalException == null ? ex : originalException;
                this.handleExceptions(ex, i);
                continue;
            }
        }
        throw originalException;
    }

    public final void close(Object sender) throws NamingException {
        if (sender == this.connector) {
            if (this.context_d != null) {
                this.context_d.close();
                this.context_d = null;
            }
            this.autoReopen_d = false;
        }
    }

    @Override
    public final Name composeName(Name s1, Name s2) throws NamingException {
        NamingException originalException = null;
        for (int i = 0; i < FaultTolerantContext.getRetryTimes(); ++i) {
            try {
                return this.getContext().composeName(s1, s2);
            }
            catch (NamingException ex) {
                originalException = originalException == null ? ex : originalException;
                this.handleExceptions(ex, i);
                continue;
            }
        }
        throw originalException;
    }

    @Override
    public final String composeName(String s1, String s2) throws NamingException {
        NamingException originalException = null;
        for (int i = 0; i < FaultTolerantContext.getRetryTimes(); ++i) {
            try {
                return this.getContext().composeName(s1, s2);
            }
            catch (NamingException ex) {
                originalException = originalException == null ? ex : originalException;
                this.handleExceptions(ex, i);
                continue;
            }
        }
        throw originalException;
    }

    @Override
    public final Context createSubcontext(Name name) throws NamingException {
        NamingException originalException = null;
        for (int i = 0; i < FaultTolerantContext.getRetryTimes(); ++i) {
            try {
                return this.getContext().createSubcontext(name);
            }
            catch (NamingException ex) {
                originalException = originalException == null ? ex : originalException;
                this.handleExceptions(ex, i);
                continue;
            }
        }
        throw originalException;
    }

    @Override
    public final Context createSubcontext(String name) throws NamingException {
        NamingException originalException = null;
        for (int i = 0; i < FaultTolerantContext.getRetryTimes(); ++i) {
            try {
                return this.getContext().createSubcontext(name);
            }
            catch (NamingException ex) {
                originalException = originalException == null ? ex : originalException;
                this.handleExceptions(ex, i);
                continue;
            }
        }
        throw originalException;
    }

    @Override
    public final void destroySubcontext(Name name) throws NamingException {
        NamingException originalException = null;
        for (int i = 0; i < FaultTolerantContext.getRetryTimes(); ++i) {
            try {
                this.getContext().destroySubcontext(name);
                return;
            }
            catch (NamingException ex) {
                originalException = originalException == null ? ex : originalException;
                this.handleExceptions(ex, i);
                continue;
            }
        }
        throw originalException;
    }

    @Override
    public final void destroySubcontext(String name) throws NamingException {
        NamingException originalException = null;
        for (int i = 0; i < FaultTolerantContext.getRetryTimes(); ++i) {
            try {
                this.getContext().destroySubcontext(name);
                return;
            }
            catch (NamingException ex) {
                originalException = originalException == null ? ex : originalException;
                this.handleExceptions(ex, i);
                continue;
            }
        }
        throw originalException;
    }

    public final NamingEnumeration list(Name name) throws NamingException {
        NamingException originalException = null;
        for (int i = 0; i < FaultTolerantContext.getRetryTimes(); ++i) {
            try {
                return this.getContext().list(name);
            }
            catch (NamingException ex) {
                originalException = originalException == null ? ex : originalException;
                this.handleExceptions(ex, i);
                continue;
            }
        }
        throw originalException;
    }

    public final NamingEnumeration list(String name) throws NamingException {
        NamingException originalException = null;
        for (int i = 0; i < FaultTolerantContext.getRetryTimes(); ++i) {
            try {
                return this.getContext().list(name);
            }
            catch (NamingException ex) {
                originalException = originalException == null ? ex : originalException;
                this.handleExceptions(ex, i);
                continue;
            }
        }
        throw originalException;
    }

    public final NamingEnumeration listBindings(Name name) throws NamingException {
        NamingException originalException = null;
        for (int i = 0; i < FaultTolerantContext.getRetryTimes(); ++i) {
            try {
                return this.getContext().listBindings(name);
            }
            catch (NamingException ex) {
                originalException = originalException == null ? ex : originalException;
                this.handleExceptions(ex, i);
                continue;
            }
        }
        throw originalException;
    }

    public final NamingEnumeration listBindings(String name) throws NamingException {
        NamingException originalException = null;
        for (int i = 0; i < FaultTolerantContext.getRetryTimes(); ++i) {
            try {
                return this.getContext().listBindings(name);
            }
            catch (NamingException ex) {
                originalException = originalException == null ? ex : originalException;
                this.handleExceptions(ex, i);
                continue;
            }
        }
        throw originalException;
    }

    @Override
    public final Object lookup(Name s) throws NamingException {
        NamingException originalException = null;
        for (int i = 0; i < FaultTolerantContext.getRetryTimes(); ++i) {
            try {
                return this.getContext().lookup(s);
            }
            catch (NamingException ex) {
                originalException = originalException == null ? ex : originalException;
                this.handleExceptions(ex, i);
                continue;
            }
        }
        throw originalException;
    }

    @Override
    public final Object lookup(String s) throws NamingException {
        NamingException originalException = null;
        for (int i = 0; i < FaultTolerantContext.getRetryTimes(); ++i) {
            try {
                return this.getContext().lookup(s);
            }
            catch (NamingException ex) {
                originalException = originalException == null ? ex : originalException;
                this.handleExceptions(ex, i);
                continue;
            }
        }
        throw originalException;
    }

    @Override
    public final Object lookupLink(Name s) throws NamingException {
        NamingException originalException = null;
        for (int i = 0; i < FaultTolerantContext.getRetryTimes(); ++i) {
            try {
                return this.getContext().lookupLink(s);
            }
            catch (NamingException ex) {
                originalException = originalException == null ? ex : originalException;
                this.handleExceptions(ex, i);
                continue;
            }
        }
        throw originalException;
    }

    @Override
    public final Object lookupLink(String s) throws NamingException {
        NamingException originalException = null;
        for (int i = 0; i < FaultTolerantContext.getRetryTimes(); ++i) {
            try {
                return this.getContext().lookupLink(s);
            }
            catch (NamingException ex) {
                originalException = originalException == null ? ex : originalException;
                this.handleExceptions(ex, i);
                continue;
            }
        }
        throw originalException;
    }

    @Override
    public final void rebind(Name name, Object obj) throws NamingException {
        NamingException originalException = null;
        for (int i = 0; i < FaultTolerantContext.getRetryTimes(); ++i) {
            try {
                this.getContext().rebind(name, obj);
                return;
            }
            catch (NamingException ex) {
                originalException = originalException == null ? ex : originalException;
                this.handleExceptions(ex, i);
                continue;
            }
        }
        throw originalException;
    }

    @Override
    public final void rebind(String name, Object obj) throws NamingException {
        NamingException originalException = null;
        for (int i = 0; i < FaultTolerantContext.getRetryTimes(); ++i) {
            try {
                this.getContext().rebind(name, obj);
                return;
            }
            catch (NamingException ex) {
                originalException = originalException == null ? ex : originalException;
                this.handleExceptions(ex, i);
                continue;
            }
        }
        throw originalException;
    }

    @Override
    public final Object removeFromEnvironment(String s) throws NamingException {
        NamingException originalException = null;
        for (int i = 0; i < FaultTolerantContext.getRetryTimes(); ++i) {
            try {
                return this.getContext().removeFromEnvironment(s);
            }
            catch (NamingException ex) {
                originalException = originalException == null ? ex : originalException;
                this.handleExceptions(ex, i);
                continue;
            }
        }
        throw originalException;
    }

    @Override
    public final void rename(Name name1, Name name2) throws NamingException {
        NamingException originalException = null;
        for (int i = 0; i < FaultTolerantContext.getRetryTimes(); ++i) {
            try {
                this.getContext().rename(name1, name2);
                return;
            }
            catch (NamingException ex) {
                originalException = originalException == null ? ex : originalException;
                this.handleExceptions(ex, i);
                continue;
            }
        }
        throw originalException;
    }

    @Override
    public final void rename(String name1, String name2) throws NamingException {
        NamingException originalException = null;
        for (int i = 0; i < FaultTolerantContext.getRetryTimes(); ++i) {
            try {
                this.getContext().rename(name1, name2);
                return;
            }
            catch (NamingException ex) {
                originalException = originalException == null ? ex : originalException;
                this.handleExceptions(ex, i);
                continue;
            }
        }
        throw originalException;
    }

    @Override
    public final void unbind(Name name) throws NamingException {
        NamingException originalException = null;
        for (int i = 0; i < FaultTolerantContext.getRetryTimes(); ++i) {
            try {
                this.getContext().unbind(name);
                return;
            }
            catch (NamingException ex) {
                originalException = originalException == null ? ex : originalException;
                this.handleExceptions(ex, i);
                continue;
            }
        }
        throw originalException;
    }

    @Override
    public final void unbind(String name) throws NamingException {
        NamingException originalException = null;
        for (int i = 0; i < FaultTolerantContext.getRetryTimes(); ++i) {
            try {
                this.getContext().unbind(name);
                return;
            }
            catch (NamingException ex) {
                originalException = originalException == null ? ex : originalException;
                this.handleExceptions(ex, i);
                continue;
            }
        }
        throw originalException;
    }

    public boolean isCached() {
        return this.cached;
    }

    public void setCached(boolean cached) {
        this.cached = cached;
    }

    protected Context createContext() throws NamingException {
        return new InitialContext(this.properties_d);
    }

    protected void handleExceptions(NamingException ex, int attempt) throws NamingException {
        if (ex instanceof ServiceUnavailableException) {
            Log.logInfo(ex);
            Utilities.sleep(1000L);
            return;
        }
        if (ex instanceof CommunicationException) {
            Log.logInfo(ex);
            if (ex.getRootCause() instanceof InvalidSearchFilterException) {
                throw (InvalidSearchFilterException)ex.getRootCause();
            }
            if (ex.getRootCause() instanceof ConnectIOException || ex.getRootCause() instanceof ServerException) {
                Utilities.sleep(500L);
            }
            Utilities.sleep(1000L);
            boolean canRetry = true;
            for (int i = 0; i < FaultTolerantContext.getConnectionRetries() && canRetry; ++i) {
                try {
                    this.reOpenContext(i);
                    LibMsg.RECONNECTED(attempt).logInfo();
                    return;
                }
                catch (NamingException ex2) {
                    canRetry = false;
                    if (!(ex2 instanceof CommunicationException)) continue;
                    Log.logInfo(ex2);
                    if (ex2.getRootCause() instanceof ConnectIOException || ex2.getRootCause() instanceof ServerException) {
                        Utilities.sleep(500L);
                    }
                    canRetry = true;
                    Utilities.sleep(1000 * (2 << i));
                    continue;
                }
            }
        }
        throw ex;
    }

    protected void reOpenContext(int attempt) throws NamingException {
        LibMsg.RECONNECTING(attempt).logInfo();
        if (this.context_d != null) {
            this.context_d.close();
            this.context_d = null;
        }
        this.autoReopen_d = true;
        this.context_d = this.createContext();
    }

    private Context getContext() throws NamingException {
        if (this.context_d == null) {
            if (this.autoReopen_d) {
                this.context_d = this.createContext();
            } else {
                LibMsg.ATTEMPTING_TO_USE_CLOSED_CONNECTION.logWarning();
                throw new RuntimeException(LibMsg.ATTEMPTING_TO_USE_CLOSED_CONNECTION.getString());
            }
        }
        return this.context_d;
    }
}

