/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.io;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;

public class TokenReader {
    private int count_d;
    private StringBuffer lastToken_d;
    private Reader reader_d;
    private int unread_d;
    public static final int EOF = -1;
    public static final int EMPTY = -2;
    public static final int WORD = -3;
    public static final int STRING = -4;

    public TokenReader(Reader reader) {
        this.reader_d = reader;
        this.lastToken_d = new StringBuffer();
        this.unread_d = -2;
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        int tokenType;
        long t0 = System.currentTimeMillis();
        String name = null;
        String implementation = null;
        TokenReader in = new TokenReader(new BufferedReader(new FileReader(args[0])));
        while ((tokenType = in.getToken()) != -1) {
            if (tokenType != -3) continue;
            String attribute = in.getTokenText();
            while ((tokenType = in.getToken()) == -3) {
                attribute = in.getTokenText();
            }
            if (tokenType != 61 || in.getToken() != -4) continue;
            String value = in.getTokenText();
            if (attribute.equals("name")) {
                name = value;
                continue;
            }
            if (!attribute.equals("implementationName")) continue;
            implementation = value;
            break;
        }
        long t1 = System.currentTimeMillis();
        System.out.println("Elapsed = " + (t1 - t0));
        System.out.println("name = " + name);
        System.out.println("implementation = " + implementation);
    }

    public int getToken() throws IOException {
        this.lastToken_d.setLength(0);
        int c = this.skipWhitespace();
        if (c == -1) {
            return -1;
        }
        if (Character.isLetter((char)c)) {
            do {
                this.lastToken_d.append((char)c);
            } while ((c = this.read()) != -1 && Character.isLetter((char)c));
            this.unread(c);
            return -3;
        }
        if (c == 34) {
            c = this.read();
            while (c != -1 && c != 34) {
                this.lastToken_d.append((char)c);
                c = this.read();
            }
            if (c != 34) {
                this.unread(c);
            }
            return -4;
        }
        this.lastToken_d.append((char)c);
        return c;
    }

    public String getTokenText() {
        return this.lastToken_d.toString();
    }

    public void close() throws IOException {
        this.reader_d.close();
        this.unread_d = -1;
    }

    public final int read() throws IOException {
        int ch;
        if (this.unread_d == -1) {
            ch = -1;
        } else if (this.unread_d == -2) {
            ch = this.reader_d.read();
            ++this.count_d;
        } else {
            ch = this.unread_d;
            this.unread_d = -2;
        }
        return ch;
    }

    public final int skipWhitespace() throws IOException {
        int c = this.read();
        while (c != -1 && Character.isWhitespace((char)c)) {
            c = this.read();
        }
        return c;
    }

    public int getCount() {
        return this.count_d;
    }

    public void unread(int i) {
        this.unread_d = i;
    }
}

