/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.io;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DelayedOutputStream
extends OutputStream {
    private InputStream check_d;
    private File file_d;
    private OutputStream out_d;
    private boolean overwritten_d;

    public DelayedOutputStream(String name) throws IOException {
        this(new File(name));
    }

    public DelayedOutputStream(File f) throws IOException {
        this.file_d = f;
        try {
            this.check_d = new BufferedInputStream(new FileInputStream(f));
            this.out_d = new ByteArrayOutputStream();
        }
        catch (IOException e) {
            this.overwritten_d = true;
            this.out_d = new FileOutputStream(f);
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.overwritten()) {
            if (!this.checkEof()) {
                this.forceWrite();
            } else {
                this.stopChecking();
            }
        }
        this.out_d.close();
    }

    @Override
    public synchronized void flush() throws IOException {
        this.out_d.flush();
    }

    public final boolean overwritten() {
        return this.overwritten_d;
    }

    public synchronized void forceWrite() throws IOException {
        if (this.overwritten()) {
            return;
        }
        ByteArrayOutputStream saved = (ByteArrayOutputStream)this.out_d;
        this.out_d = new FileOutputStream(this.file_d);
        this.stopChecking();
        this.overwritten_d = true;
        saved.writeTo(this.out_d);
    }

    public synchronized void stopChecking() {
        if (this.overwritten()) {
            return;
        }
        try {
            this.check_d.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.check_d = null;
    }

    @Override
    public synchronized void write(int b) throws IOException {
        if (!this.overwritten() && !this.check(b)) {
            this.forceWrite();
        }
        this.out_d.write(b);
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (!this.overwritten() && !this.check(b, off, len)) {
            this.forceWrite();
        }
        this.out_d.write(b, off, len);
    }

    private boolean check(int b) {
        try {
            if (this.check_d.read() == (b & 0xFF)) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private boolean check(byte[] b, int off, int len) {
        while (len > 0) {
            try {
                if (this.check_d.read() != (b[off] & 0xFF)) {
                    return false;
                }
            }
            catch (IOException e) {
                return false;
            }
            ++off;
            --len;
        }
        return true;
    }

    private boolean checkEof() {
        try {
            if (this.check_d.read() == -1) {
                return true;
            }
        }
        catch (EOFException e) {
            return true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }
}

