/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.io;

import java.io.IOException;
import java.io.OutputStream;
import oracle.bpm.io.TransportBlock;

public class BlockWriter {
    protected int index_d = 0;
    protected OutputStream os_d = null;

    public BlockWriter() {
    }

    public BlockWriter(OutputStream os) {
        if (os == null) {
            throw new IllegalArgumentException("Output Stream must not be null");
        }
        this.os_d = os;
    }

    public void setIndex(int i) {
        if (i <= 0) {
            throw new RuntimeException("Writer Index(" + i + ") should always be > 0");
        }
        this.index_d = i;
    }

    public int getIndex() {
        return this.index_d;
    }

    public void abort() throws IOException {
    }

    public void close() throws IOException {
        this.os_d.close();
        this.os_d = null;
    }

    public void write(TransportBlock block) throws IOException {
        if (this.os_d == null) {
            throw new IOException("Stream Closed");
        }
        if (block.index != this.index_d) {
            throw new IllegalArgumentException("BlockWriter and TransportBlock Index mismatch!");
        }
        this.os_d.write(block.data);
        if (!block.hasNext) {
            this.close();
        }
    }

    protected void finalize() throws Exception {
        if (this.os_d != null) {
            this.close();
        }
    }
}

