/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import oracle.bpm.http.HttpCommand;
import oracle.bpm.http.HttpCommandServer;
import oracle.bpm.http.HttpException;
import oracle.bpm.http.HttpRequest;
import oracle.bpm.http.HttpResponse;
import oracle.bpm.log.Log;

class HttpWorker
extends Thread {
    private HttpCommandServer server;
    private Socket socket;
    private boolean working;
    private static int count;

    HttpWorker(ThreadGroup group, HttpCommandServer server) {
        super(group, "HttpWorker-" + ++count);
        this.server = server;
        this.working = true;
    }

    @Override
    public synchronized void run() {
        while (this.working && !Thread.interrupted()) {
            if (this.socket != null) {
                try {
                    this.process(this.socket);
                }
                catch (IOException e) {
                    // empty catch block
                }
                this.socket = null;
                continue;
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    boolean isLocked() {
        return this.socket != null;
    }

    synchronized void setSocket(Socket socket) {
        if (this.socket != null) {
            throw new IllegalStateException();
        }
        this.socket = socket;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(Socket client) throws IOException {
        client.setTcpNoDelay(true);
        int timeout = this.server.getTimeout();
        if (timeout > 0) {
            client.setSoTimeout(timeout);
        }
        InputStream in = client.getInputStream();
        OutputStream out = client.getOutputStream();
        try {
            HttpRequest request = HttpRequest.createFrom(in);
            String file = request.getPath();
            HttpCommand command = this.server.getCommandForPath(file);
            if (command == null) {
                throw new HttpException(404, "NOT FOUND");
            }
            HttpResponse response = new HttpResponse();
            command.process(request, response);
            response.send(out);
        }
        catch (HttpException e) {
            HttpResponse error = new HttpResponse();
            error.setStatus(e.getStatus());
            error.send(out);
        }
        catch (Throwable e) {
            Log.logSevere(e);
            HttpResponse error = new HttpResponse();
            error.setStatus(500);
            error.send(out);
        }
        finally {
            client.shutdownOutput();
            client.close();
        }
    }
}

