/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.http;

import java.io.IOException;
import java.io.PrintStream;
import oracle.bpm.http.AbstractHttpCommand;
import oracle.bpm.http.Cookie;
import oracle.bpm.http.HttpCommand;
import oracle.bpm.http.HttpRequest;
import oracle.bpm.http.HttpResponse;

public class AuthenticatedCommand
extends AbstractHttpCommand {
    public AuthenticatedCommand(HttpCommand command) {
        super(command.getName(), command.getDescription(), command.getGroup());
    }

    @Override
    public void process(HttpRequest request, HttpResponse response) throws IOException {
        Cookie cookie = Cookie.parse(request);
        String sessionId = null;
        if (cookie != null) {
            sessionId = cookie.getAttribute("sessionId");
        }
        if (sessionId == null) {
            AuthenticatedCommand.login(request, response.getPrintStream());
        }
    }

    private static void login(HttpRequest request, PrintStream out) throws IOException {
        out.println(AuthenticatedCommand.loginForm(request.getPath()));
    }

    private static String loginForm(String file) {
        StringBuilder form = new StringBuilder();
        form.append("<form action=/login method=get>\n");
        form.append("<input type=password name=password size=12>");
        form.append("<input type=submit value=Login name=login>");
        form.append("<input type=hidden value=").append(file).append(" name=file>");
        form.append("</form>\n");
        return form.toString();
    }
}

