/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.holidays;

import fuego.directory.DirHolidayRule;
import fuego.directory.DirectorySession;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import oracle.bpm.holidays.Holiday;
import oracle.bpm.holidays.HolidayCalendar;
import oracle.bpm.lang.DynamicObject;
import oracle.bpm.lang.HolidayRule;
import oracle.bpm.log.Log;
import oracle.bpm.xml.DeserializationException;
import oracle.bpm.xml.XMLDeserializer;

public class HolidayCalendarLoader {
    public static ArrayList legacyLoad(String text) throws UnsupportedEncodingException, DeserializationException {
        ByteArrayInputStream istr = new ByteArrayInputStream(text.getBytes("ISO8859_1"));
        XMLDeserializer deserializer = new XMLDeserializer();
        DynamicObject dynamic = deserializer.parse(istr);
        HolidayRule oldRule = dynamic.convertTo(HolidayRule.class);
        return oldRule.getItems();
    }

    public static HolidayCalendar load(DirectorySession session, String name) {
        HolidayCalendar result = null;
        if (name != null && name.length() > 0) {
            try {
                result = HolidayCalendarLoader.load(DirHolidayRule.fetch(session, name));
            }
            catch (Exception e) {
                Log.logWarning(e);
            }
        }
        return result;
    }

    public static HolidayCalendar load(DirHolidayRule dirRule) {
        HolidayCalendar result = null;
        if (dirRule != null) {
            try {
                String name = dirRule.getName();
                String text = dirRule.getProperties();
                if (text != null) {
                    result = (text = text.trim()).startsWith("<") ? HolidayCalendarLoader.legacyLoad(name, text) : HolidayCalendar.valueOf(name, text);
                }
            }
            catch (Exception e) {
                Log.logWarning(e);
            }
        }
        return result;
    }

    public static HolidayCalendar legacyLoad(String name, String text) throws DeserializationException, UnsupportedEncodingException {
        ArrayList old = HolidayCalendarLoader.legacyLoad(text);
        Holiday[] holidays = HolidayCalendarLoader.convert(old);
        return new HolidayCalendar(name, holidays);
    }

    private static Holiday[] convert(ArrayList old) {
        Holiday[] holidays = new Holiday[old.size()];
        for (int i = 0; i < old.size(); ++i) {
            String holidaySpec = old.get(i).toString();
            Holiday holiday = Holiday.valueOf(holidaySpec);
            assert (holiday != null) : "Invalid spec: " + holidaySpec;
            holidays[i] = holiday;
        }
        return holidays;
    }
}

