/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.connector.impl;

import java.util.Stack;
import javax.ejb.EJBContext;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.transaction.UserTransaction;
import oracle.bpm.lang.SuspendableThreadLocal;

public abstract class UserTransactionProvider {
    private final Context context;
    static final ThreadLocalStack stacks = new ThreadLocalStack();

    protected UserTransactionProvider(Context context) {
        this.context = context;
    }

    public abstract UserTransaction getUserTransaction();

    public static UserTransactionProvider createForBean(Context context, EJBContext ejbContext) {
        return new BeanContext(context, ejbContext);
    }

    public static UserTransactionProvider createForServlets(Context context) throws NamingException {
        return new ServletContext(context, (UserTransaction)context.lookup("java:comp/UserTransaction"));
    }

    public static UserTransactionProvider get() {
        return (UserTransactionProvider)stacks.peek();
    }

    public Context getContext() {
        return this.context;
    }

    public void set() {
        stacks.push(this);
    }

    public void unset() {
        stacks.pop(this);
    }

    private static class ThreadLocalStack
    extends SuspendableThreadLocal<Stack<UserTransactionProvider>> {
        private ThreadLocalStack() {
        }

        public Stack<UserTransactionProvider> getStack() {
            return (Stack)this.get();
        }

        public Object peek() {
            Stack<UserTransactionProvider> stack = this.getStack();
            return stack.isEmpty() ? null : stack.peek();
        }

        public Object pop(UserTransactionProvider item) {
            UserTransactionProvider pop = this.getStack().pop();
            assert (pop == item) : "popping from the stack a UserTransactionProvider different that me ";
            return pop;
        }

        public Object push(UserTransactionProvider item) {
            return this.getStack().push(item);
        }

        @Override
        protected Stack<UserTransactionProvider> initialValue() {
            return new Stack<UserTransactionProvider>();
        }
    }

    private static class ServletContext
    extends UserTransactionProvider {
        private final UserTransaction userTransaction;

        public ServletContext(Context context, UserTransaction userTransaction) {
            super(context);
            assert (userTransaction != null);
            this.userTransaction = userTransaction;
        }

        @Override
        public UserTransaction getUserTransaction() {
            return this.userTransaction;
        }
    }

    public static class BeanContext
    extends UserTransactionProvider {
        private final EJBContext ejbContext;

        public BeanContext(Context context, EJBContext ejbContext) {
            super(context);
            this.ejbContext = ejbContext;
        }

        @Override
        public UserTransaction getUserTransaction() {
            return this.ejbContext.getUserTransaction();
        }
    }
}

