/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.connector.impl;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import oracle.bpm.connector.impl.StatementExecutedListener;
import oracle.bpm.lang.Int;
import oracle.bpm.util.ObjectWatch;

public class StatementHolder
implements StatementExecutedListener {
    private Map<String, Integer> executedStatements = Collections.synchronizedMap(new TreeMap());
    private static StatementHolder instance;

    private StatementHolder() {
    }

    public static StatementHolder getInstance() {
        if (instance == null) {
            instance = new StatementHolder();
        }
        return instance;
    }

    public Map<String, Integer> getExecutedStatements() {
        return Collections.unmodifiableMap(this.executedStatements);
    }

    @Override
    public void statementExecuted(String stmt) {
        Integer nExecuted = this.executedStatements.get(stmt);
        if (nExecuted == null) {
            nExecuted = Int.ZERO;
        }
        nExecuted = Int.inc(nExecuted);
        this.executedStatements.put(stmt, nExecuted);
    }

    static {
        ObjectWatch.register("pools and caches", "Server Executed Statements", "# Server executed statements", StatementHolder.getInstance().executedStatements);
    }
}

