/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.connector.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import oracle.bpm.configuration.exception.InvalidConfigurationException;
import oracle.bpm.configuration.spi.ConfigurationEditorBean;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.util.NetURL;

public class ServerConfiguration
implements ConfigurationEditorBean {
    private String hostName;
    private String password;
    private String path;
    private Integer port;
    private String protocol;
    private boolean requiredHttpBasicAuth;
    private int timeout;
    private String url;
    private String username;
    private static final int SIXTY_SECONDS = 60;
    public static final String HTTP_PROTOCOL = "http";
    public static final String HTTPS_PROTOCOL = "https";
    private static final String DEFAULT_HOST = "";
    public static final int DEFAULT_HTTP_PORT = 80;
    public static final int DEFAULT_HTTPS_PORT = 443;
    private static final String DEFAULT_PATH = "";

    public ServerConfiguration(Properties properties) {
        this.url = properties.getProperty("url");
        this.username = properties.getProperty("username");
        this.password = properties.getProperty("password");
        String timeoutStr = (String)properties.get("timeout");
        this.timeout = timeoutStr != null ? Integer.parseInt(timeoutStr) : 60;
        this.requiredHttpBasicAuth = this.username != null && this.username.length() > 0;
        this.initVarialbles();
    }

    public static String formatPath(String path) {
        path = path != null ? path : "";
        if (!"".equals(path = path.trim()) && path.charAt(0) != '/') {
            path = '/' + path;
        }
        return path;
    }

    public static List<String> getProtocolsList() {
        ArrayList<String> protocolList = new ArrayList<String>();
        protocolList.add(HTTP_PROTOCOL);
        protocolList.add(HTTPS_PROTOCOL);
        return protocolList;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.hostName;
    }

    public int getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setHost(String hostName) {
        this.hostName = hostName;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setPath(String path) {
        if (path != null) {
            this.path = path;
        }
    }

    public String getUrl() {
        String fullUrl = this.buildFullUrl();
        if (fullUrl != null) {
            return fullUrl;
        }
        return "";
    }

    @Override
    public Properties asProperties() {
        Properties properties = new Properties();
        properties.put("url", this.getUrl());
        if (this.requiredHttpBasicAuth) {
            properties.put("username", this.username);
            properties.put("password", this.password);
        }
        properties.setProperty("timeout", String.valueOf(this.timeout));
        return properties;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public boolean isRequiredHttpBasicAuth() {
        return this.requiredHttpBasicAuth;
    }

    public boolean isNotRequiredHttpBasicAuth() {
        return !this.isRequiredHttpBasicAuth();
    }

    public void setRequiredHttpBasicAuth(boolean requiredHttpBasicAuth) {
        this.requiredHttpBasicAuth = requiredHttpBasicAuth;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public void check() throws Exception {
    }

    @Override
    public void validate() throws InvalidConfigurationException {
        String urlValue = this.buildFullUrl();
        if (urlValue.trim().equals("")) {
            throw InvalidConfigurationException.validationFailed(LibMsg.URL_EMPTY);
        }
        if (this.hostName == null || "".equals(this.hostName)) {
            throw InvalidConfigurationException.validationFailed(LibMsg.HOST_EMPTY);
        }
        if (this.isRequiredHttpBasicAuth()) {
            if (this.username == null || "".equals(this.username.trim())) {
                throw InvalidConfigurationException.validationFailed(LibMsg.USER_EMPTY);
            }
            if (this.password == null || "".equals(this.password.trim())) {
                throw InvalidConfigurationException.validationFailed(LibMsg.PASSWORD_EMPTY);
            }
            if (this.timeout <= 0) {
                throw InvalidConfigurationException.validationFailed(LibMsg.TIMEOUT_GREATER_ZERO);
            }
        }
    }

    private void initVarialbles() {
        if (this.url != null && !this.url.trim().equals("")) {
            NetURL netURL = new NetURL(this.url);
            this.protocol = netURL.getProtocol();
            this.hostName = netURL.getHost();
            this.port = netURL.getPort();
            if (this.port == -1) {
                String protocol = this.getProtocol();
                if (HTTP_PROTOCOL.equals(protocol)) {
                    this.port = 80;
                } else if (HTTPS_PROTOCOL.equals(protocol)) {
                    this.port = 443;
                }
            }
            this.path = netURL.getFile();
        } else {
            this.protocol = HTTP_PROTOCOL;
            this.hostName = "";
            this.port = 80;
            this.path = "";
        }
    }

    private String buildFullUrl() {
        String finalPath = ServerConfiguration.formatPath(this.path);
        StringBuilder fullUrl = new StringBuilder();
        fullUrl.append(this.protocol);
        fullUrl.append("://");
        fullUrl.append(this.hostName);
        fullUrl.append(":");
        fullUrl.append(this.port);
        fullUrl.append(finalPath);
        return fullUrl.toString();
    }
}

