/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.connector.impl;

import java.util.List;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.xa.XAResource;
import oracle.bpm.connector.impl.BaseTransactionCoordinator;
import oracle.bpm.extension.Extension;
import oracle.bpm.extension.ExtensionService;
import oracle.bpm.extensionpoint.metadata.TransactionCoordinatorMetadata;
import oracle.bpm.jdbc.FaultTolerantConnection;
import oracle.bpm.lang.Platform;
import oracle.bpm.log.Log;
import oracle.bpm.pool.Cache;

public abstract class LocalTransactionCoordinator
extends BaseTransactionCoordinator {
    private static LocalTransactionCoordinator instance = null;

    protected LocalTransactionCoordinator() {
    }

    public abstract void delistResource(XAResource var1, int var2) throws SystemException;

    public abstract void enlistResource(XAResource var1, boolean var2) throws SystemException, NotSupportedException, RollbackException;

    public static LocalTransactionCoordinator getInstance() {
        if (instance == null) {
            LocalTransactionCoordinator.createCoordinator();
        }
        return instance;
    }

    protected void release(List resources) {
        if (resources != null) {
            for (Object o : resources) {
                FaultTolerantConnection connection;
                Cache pool;
                if (!(o instanceof FaultTolerantConnection) || (pool = (connection = (FaultTolerantConnection)o).getPool()) == null) continue;
                pool.unlock(connection);
            }
        }
    }

    private static synchronized void createCoordinator() {
        ExtensionService service;
        List<Extension<TransactionCoordinatorMetadata>> extensions;
        if (instance == null && !(extensions = (service = Platform.getExtensionService()).getExtensionsByPoint(TransactionCoordinatorMetadata.class)).isEmpty()) {
            try {
                instance = extensions.get(0).instantiateAs(LocalTransactionCoordinator.class);
            }
            catch (InstantiationException e) {
                Log.logSevere(e);
            }
        }
    }
}

