/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.connector.impl;

import java.util.Properties;
import oracle.bpm.configuration.ConfigType;
import oracle.bpm.configuration.Configuration;
import oracle.bpm.configuration.KnownConfigTypes;
import oracle.bpm.connector.ConnectorService;
import oracle.bpm.connector.impl.LocalJ2EEConnector;
import oracle.bpm.connector.impl.LocalJ2eeConfigType;
import oracle.bpm.connector.impl.RemoteJdbcConfigType;
import oracle.bpm.connector.spi.ConnectorFactory;
import oracle.bpm.connector.spi.ConnectorInterface;
import oracle.bpm.extensionpoint.metadata.ConnectorFactoryMetadata;

@ConnectorFactoryMetadata(configType={"J2EE", "LOCAL_J2EE"})
public class LocalJ2EEFactory
extends ConnectorFactory {
    public static final String TABLE_PREFIX = "table.prefix";
    public static final String INTERNAL_CONNECTOR_NAME = "__internal__";

    public static Configuration createDirectoryConnector(String lookupName, String connectorSubType, String tablePrefix) {
        Configuration directoryConnector = new Configuration("fuego", KnownConfigTypes.SQL);
        directoryConnector.setConfigType(RemoteJdbcConfigType.get());
        directoryConnector.getProperties().setProperty("lookupName", lookupName);
        directoryConnector.getProperties().setProperty("j2ee.provider", INTERNAL_CONNECTOR_NAME);
        directoryConnector.getProperties().setProperty("jdbc.remote.type", connectorSubType);
        if (tablePrefix != null) {
            directoryConnector.getProperties().setProperty(TABLE_PREFIX, tablePrefix);
        }
        return directoryConnector;
    }

    public static Configuration createInternalJ2EEConnector() {
        Configuration internalJ2ee = new Configuration(INTERNAL_CONNECTOR_NAME, KnownConfigTypes.J2EE);
        internalJ2ee.setConfigType(LocalJ2eeConfigType.get());
        return internalJ2ee;
    }

    @Override
    public ConfigType getConfigType() {
        return LocalJ2eeConfigType.get();
    }

    @Override
    public ConnectorInterface createConnector(ConnectorService manager, String name, Properties properties) {
        return new LocalJ2EEConnector(this, manager, name, properties);
    }
}

