/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.connector.impl;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import oracle.bpm.configuration.ConfigType;
import oracle.bpm.configuration.JndiConfigType;
import oracle.bpm.configuration.util.ValidationUtilities;
import oracle.bpm.connector.ConnectorService;
import oracle.bpm.connector.ConnectorTransactionCoordinator;
import oracle.bpm.connector.impl.BaseConnector;
import oracle.bpm.connector.impl.pool.PoolManager;
import oracle.bpm.connector.impl.pool.PooledFactory;
import oracle.bpm.connector.spi.ConnectorFactory;
import oracle.bpm.connector.spi.ConnectorInterface;
import oracle.bpm.connector.spi.JNDIConnectorInterface;
import oracle.bpm.jndi.FaultTolerantContext;
import oracle.bpm.jndi.FaultTolerantDirContext;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.log.Log;
import oracle.bpm.pool.CacheFactoryException;

public class JNDIConnector
extends BaseConnector
implements JNDIConnectorInterface,
ConnectorTransactionCoordinator {
    private ContextFactory contextFactory;
    private PoolManager<FaultTolerantContext> contextPoolManager;
    private DirContextFactory dirContextFactory;
    private PoolManager<FaultTolerantDirContext> dirContextPoolManager;

    JNDIConnector(ConnectorFactory factory, ConnectorService manager, String name, Properties properties) {
        super(factory, manager, name, properties);
        Properties cacheProperties = new Properties();
        cacheProperties.setProperty("fuego.cache.maxentrysize", String.valueOf(10000));
        cacheProperties.setProperty("fuego.cache.minnodisposable", String.valueOf(2));
        this.contextFactory = new ContextFactory();
        this.dirContextFactory = new DirContextFactory();
        this.contextPoolManager = PoolManager.create(this.contextFactory, this.getName() + "_context", cacheProperties, this.getProperties());
        this.dirContextPoolManager = PoolManager.create(this.dirContextFactory, this.getName() + "_dircontext", cacheProperties, this.getProperties());
    }

    @Override
    public Context getContext() throws NamingException {
        return this.getContext(null);
    }

    @Override
    public String getCoordinatorKey() {
        return this.getName();
    }

    @Override
    public DirContext getDirContext() throws NamingException {
        return this.getDirContext(null);
    }

    @Override
    public Context getContext(Properties authenticationProperties) throws NamingException {
        Context context;
        try {
            context = this.contextPoolManager.getPooledObject(authenticationProperties);
        }
        catch (Exception e) {
            NamingException namingException = new NamingException(e.getLocalizedMessage());
            namingException.initCause(e);
            throw namingException;
        }
        return context;
    }

    @Override
    public DirContext getDirContext(Properties authenticationProperties) throws NamingException {
        DirContext dirContext;
        try {
            dirContext = this.dirContextPoolManager.getPooledObject(authenticationProperties);
        }
        catch (Exception e) {
            NamingException namingException = new NamingException(e.getLocalizedMessage());
            namingException.initCause(e);
            throw namingException;
        }
        return dirContext;
    }

    @Override
    public Object getResource() throws Exception {
        return this.getResource(null);
    }

    @Override
    public Object getResource(int resourceType) throws Exception {
        return this.getResource(resourceType, null);
    }

    @Override
    public Object getResource(Properties authenticationProperties) throws Exception {
        return this.getResource(0, authenticationProperties);
    }

    @Override
    public Object getResource(int resourceType, Properties authProperties) throws Exception {
        switch (resourceType) {
            case 1: {
                return this.getContext(authProperties);
            }
            case 0: {
                return this.getDirContext(authProperties);
            }
            case 2: {
                return this.getAtomicDirContext(authProperties);
            }
            case 3: {
                return this.getAtomicContext(authProperties);
            }
        }
        return this.getDirContext(authProperties);
    }

    @Override
    public ConfigType getConfigType() {
        return JndiConfigType.get();
    }

    @Override
    public void commit(List resources) throws Exception {
        this.closeContexts(resources);
    }

    @Override
    public ConnectorTransactionCoordinator createCoordinator() {
        return this;
    }

    @Override
    public boolean handleServiceType(String type) {
        return false;
    }

    @Override
    public void restart() {
    }

    @Override
    public void rollback(List resources) throws Exception {
        this.closeContexts(resources);
    }

    @Override
    public void start() throws Exception {
        this.contextPoolManager.start();
        this.dirContextPoolManager.start();
    }

    @Override
    public void stop() {
        this.contextPoolManager.stop();
        this.dirContextPoolManager.stop();
    }

    private static String getUserPropertyKey() {
        return "java.naming.security.principal";
    }

    private static String getPasswordPropertyKey() {
        return "java.naming.security.credentials";
    }

    private DirContext getAtomicDirContext(Properties authProperties) {
        FaultTolerantDirContext result = this.dirContextFactory.create(authProperties);
        result.setCached(false);
        return result;
    }

    private Context getAtomicContext(Properties authProperties) {
        FaultTolerantContext result = this.contextFactory.create(authProperties);
        result.setCached(false);
        return result;
    }

    private void closeContexts(List resources) throws Exception {
        boolean fail = false;
        if (resources != null) {
            for (Object resource : resources) {
                try {
                    if (resource instanceof FaultTolerantDirContext) {
                        FaultTolerantDirContext dirCtx = (FaultTolerantDirContext)resource;
                        if (dirCtx.isCached()) {
                            this.dirContextPoolManager.unlock(dirCtx);
                            continue;
                        }
                        dirCtx.close();
                        continue;
                    }
                    FaultTolerantContext ctx = (FaultTolerantContext)resource;
                    if (ctx.isCached()) {
                        this.contextPoolManager.unlock(ctx);
                        continue;
                    }
                    ctx.close();
                }
                catch (Throwable t) {
                    Log.logWarning(LibMsg.EXCEPTION_ON_CLOSE_GENERICJNDI(this.getCoordinatorKey()));
                    Log.logWarning(t);
                    fail = true;
                }
            }
        }
        if (fail) {
            throw new Exception();
        }
    }

    private class DirContextFactory
    implements PooledFactory<FaultTolerantDirContext> {
        private DirContextFactory() {
        }

        @Override
        public FaultTolerantDirContext create(Properties authenticationProperties) {
            Properties environment = new Properties();
            environment.putAll((Map<?, ?>)JNDIConnector.this.getProperties());
            environment.putAll((Map<?, ?>)JNDIConnector.this.getCustomProperties());
            if (authenticationProperties != null) {
                JNDIConnector.this.putProperty(environment, "java.naming.security.principal", authenticationProperties.getProperty("java.naming.security.principal"));
                JNDIConnector.this.putNullableProperty(environment, "java.naming.security.credentials", ValidationUtilities.unscrambleText(authenticationProperties.getProperty("java.naming.security.credentials")));
            } else {
                JNDIConnector.this.putNullableProperty(environment, "java.naming.security.credentials", JNDIConnector.this.getEncryptedProperty("java.naming.security.credentials"));
            }
            try {
                return new FaultTolerantDirContext(environment, (ConnectorInterface)JNDIConnector.this);
            }
            catch (NamingException e) {
                throw new CacheFactoryException(e);
            }
        }

        @Override
        public boolean dispose(FaultTolerantDirContext value) {
            try {
                value.close(JNDIConnector.this);
                return true;
            }
            catch (NamingException e) {
                Log.logWarning(e);
                return false;
            }
        }

        @Override
        public String getUserPropertyKey() {
            return JNDIConnector.getUserPropertyKey();
        }

        @Override
        public String getPasswordPropertyKey() {
            return JNDIConnector.getPasswordPropertyKey();
        }
    }

    private class ContextFactory
    implements PooledFactory<FaultTolerantContext> {
        private ContextFactory() {
        }

        @Override
        public FaultTolerantContext create(Properties authenticationProperties) {
            Properties environment = new Properties();
            environment.putAll((Map<?, ?>)JNDIConnector.this.getProperties());
            environment.putAll((Map<?, ?>)JNDIConnector.this.getCustomProperties());
            if (authenticationProperties != null) {
                JNDIConnector.this.putProperty(environment, "java.naming.security.principal", authenticationProperties.getProperty("java.naming.security.principal"));
                JNDIConnector.this.putNullableProperty(environment, "java.naming.security.credentials", ValidationUtilities.unscrambleText(authenticationProperties.getProperty("java.naming.security.credentials")));
            } else {
                JNDIConnector.this.putNullableProperty(environment, "java.naming.security.credentials", JNDIConnector.this.getEncryptedProperty("java.naming.security.credentials"));
            }
            try {
                return new FaultTolerantContext(environment, (ConnectorInterface)JNDIConnector.this);
            }
            catch (NamingException e) {
                throw new CacheFactoryException(e);
            }
        }

        @Override
        public boolean dispose(FaultTolerantContext value) {
            try {
                value.close(JNDIConnector.this);
                return true;
            }
            catch (NamingException e) {
                Log.logWarning(e);
                return false;
            }
        }

        @Override
        public String getUserPropertyKey() {
            return JNDIConnector.getUserPropertyKey();
        }

        @Override
        public String getPasswordPropertyKey() {
            return JNDIConnector.getPasswordPropertyKey();
        }
    }
}

