/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.connector.impl;

import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.naming.NamingException;
import oracle.bpm.configuration.ConfigType;
import oracle.bpm.configuration.KnownConfigTypes;
import oracle.bpm.connector.ConnectorException;
import oracle.bpm.connector.ConnectorService;
import oracle.bpm.connector.ConnectorTransaction;
import oracle.bpm.connector.JmsDestinationType;
import oracle.bpm.connector.impl.BaseRemoteConnector;
import oracle.bpm.connector.spi.ConnectorFactory;
import oracle.bpm.connector.spi.JMSConnectorInterface;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.log.Log;

public class JMSConnector
extends BaseRemoteConnector
implements JMSConnectorInterface,
ConnectorTransaction.Synchronization {
    private String connectionFactoryName = this.getProperty("jmsConnectionFactory");
    private JmsDestinationType destinationType = JmsDestinationType.valueOf(this.getProperty("jmsDestinationType"));

    JMSConnector(ConnectorFactory factory, ConnectorService manager, String name, Properties properties) {
        super(factory, manager, name, properties);
    }

    @Override
    public JmsDestinationType getDestinationType() {
        return this.destinationType;
    }

    @Override
    public Object getResource() throws Exception {
        return this.getResource(null);
    }

    @Override
    public Object getResource(int resourceType) throws Exception {
        return this.getResource(resourceType, null);
    }

    @Override
    public Object getResource(Properties authProperties) throws Exception {
        return this.getResource(1, authProperties);
    }

    @Override
    public Object getResource(int resourceType, Properties authProperties) throws Exception {
        switch (resourceType) {
            case 1: {
                return this.getDestination(false, authProperties);
            }
            case 5: {
                return this.getMessageConsumer(authProperties);
            }
            case 6: {
                return this.getMessageProducer(authProperties);
            }
            case 7: {
                return this.getSession(authProperties);
            }
            case 4: {
                return this.getConnection(authProperties);
            }
            case 8: {
                return this.getConnection(true, authProperties);
            }
        }
        throw new IllegalArgumentException("invalid resource type " + resourceType);
    }

    @Override
    public ConnectionFactory getStandaloneConnectionFactory() throws ConnectorException {
        return this.getStandaloneConnectionFactory(null);
    }

    @Override
    public ConnectionFactory getStandaloneConnectionFactory(Properties authenticationProperties) throws ConnectorException {
        return this.getConnectionFactory(true, authenticationProperties);
    }

    @Override
    public Destination getStandaloneDestination() throws ConnectorException {
        return this.getStandaloneDestination(null);
    }

    @Override
    public Destination getStandaloneDestination(Properties authenticationProperties) throws ConnectorException {
        return this.getDestination(true, authenticationProperties);
    }

    @Override
    public ConfigType getConfigType() {
        return KnownConfigTypes.JMS;
    }

    @Override
    public void afterCompletion(int i) {
        Connection connection = (Connection)this.obtainResource(4);
        if (connection != null) {
            try {
                connection.close();
            }
            catch (Throwable t) {
                Log.logWarning(LibMsg.EXCEPTION_ON_RELEASE_BASEJ2EE(this.getCoordinatorKey()));
                Log.logWarning(t);
            }
        }
        this.releaseResources();
    }

    @Override
    public void beforeCompletion() {
    }

    @Override
    public boolean handleServiceType(String type) {
        return false;
    }

    @Override
    public void restart() {
    }

    @Override
    public void stop() {
    }

    private Connection getConnection(Properties authProperties) throws ConnectorException {
        return this.getConnection(false, authProperties);
    }

    private Connection getConnection(boolean standalone, Properties authProperties) throws ConnectorException {
        Connection result = (Connection)this.obtainResource(4);
        if (result == null) {
            block7: {
                String username = this.getProperty("username");
                String password = this.getEncryptedProperty("password");
                boolean createAuthenticated = username != null && username.length() > 0;
                ConnectionFactory connectionFactory = this.getConnectionFactory(standalone, authProperties);
                try {
                    try {
                        result = createAuthenticated ? connectionFactory.createConnection(username, password) : connectionFactory.createConnection();
                    }
                    catch (NoSuchMethodError e) {
                        if (connectionFactory instanceof QueueConnectionFactory) {
                            result = createAuthenticated ? ((QueueConnectionFactory)connectionFactory).createQueueConnection(username, password) : ((QueueConnectionFactory)connectionFactory).createQueueConnection();
                            break block7;
                        }
                        if (connectionFactory instanceof TopicConnectionFactory) {
                            result = createAuthenticated ? ((TopicConnectionFactory)connectionFactory).createTopicConnection(username, password) : ((TopicConnectionFactory)connectionFactory).createTopicConnection();
                            break block7;
                        }
                        throw e;
                    }
                }
                catch (JMSException e) {
                    throw ConnectorException.exceptionOnGetResource(this, 4, (Exception)((Object)e));
                }
            }
            this.registerResource(4, result);
        }
        return result;
    }

    private ConnectionFactory getConnectionFactory(boolean standalone, Properties authenticationProperties) throws ConnectorException {
        try {
            return (ConnectionFactory)this.getReferencedObject(standalone, this.connectionFactoryName, authenticationProperties);
        }
        catch (ConnectorException e) {
            throw e;
        }
        catch (ClassCastException e) {
            throw ConnectorException.wrapClassCastException(this, 2, e);
        }
        catch (NamingException e) {
            throw ConnectorException.exceptionOnGetResource(this, 2, e);
        }
    }

    private Destination getDestination(boolean standalone, Properties authenticationProperties) throws ConnectorException {
        try {
            return (Destination)this.getReferencedObject(standalone, authenticationProperties);
        }
        catch (ConnectorException e) {
            throw e;
        }
        catch (ClassCastException e) {
            throw ConnectorException.wrapClassCastException(this, 2, e);
        }
        catch (NamingException e) {
            throw ConnectorException.exceptionOnGetResource(this, 1, e);
        }
    }

    private MessageConsumer getMessageConsumer(Properties authProperties) throws ConnectorException {
        MessageConsumer result = (MessageConsumer)this.obtainResource(5);
        if (result == null) {
            result = this.createMessageConsumer(authProperties);
            this.registerResource(5, result);
        }
        assert (result != null);
        return result;
    }

    private MessageProducer getMessageProducer(Properties authProperties) throws ConnectorException {
        MessageProducer result = (MessageProducer)this.obtainResource(6);
        if (result == null) {
            result = this.createMessageProducer(authProperties);
            this.registerResource(6, result);
        }
        assert (result != null);
        return result;
    }

    private Session getSession(Properties authProperties) throws ConnectorException {
        Session result = (Session)this.obtainResource(7);
        if (result == null) {
            block8: {
                Connection connection = this.getConnection(authProperties);
                try {
                    try {
                        result = connection.createSession(false, 1);
                    }
                    catch (NoSuchMethodError e) {
                        if (connection instanceof QueueConnection) {
                            result = ((QueueConnection)connection).createQueueSession(false, 1);
                            break block8;
                        }
                        if (connection instanceof TopicConnection) {
                            result = ((TopicConnection)connection).createTopicSession(false, 1);
                            break block8;
                        }
                        throw e;
                    }
                }
                catch (JMSException e) {
                    throw ConnectorException.exceptionOnGetResource(this, 7, (Exception)((Object)e));
                }
            }
            this.registerResource(7, result);
        }
        assert (result != null);
        return result;
    }

    private MessageConsumer createMessageConsumer(Properties authProperties) throws ConnectorException {
        try {
            MessageConsumer consumer;
            Destination destination = this.getDestination(false, authProperties);
            Session session = this.getSession(authProperties);
            try {
                consumer = session.createConsumer(destination);
            }
            catch (NoSuchMethodError e) {
                if (session instanceof QueueSession) {
                    consumer = ((QueueSession)session).createReceiver((Queue)destination);
                }
                if (session instanceof TopicSession) {
                    consumer = ((TopicSession)session).createSubscriber((Topic)destination);
                }
                throw e;
            }
            Connection connection = this.getConnection(authProperties);
            connection.start();
            return consumer;
        }
        catch (JMSException e) {
            throw ConnectorException.exceptionOnGetResource(this, 6, (Exception)((Object)e));
        }
    }

    private MessageProducer createMessageProducer(Properties authProperties) throws ConnectorException {
        try {
            MessageProducer producer;
            Destination destination = this.getDestination(false, authProperties);
            Session session = this.getSession(authProperties);
            try {
                producer = session.createProducer(destination);
            }
            catch (NoSuchMethodError e) {
                if (session instanceof QueueSession) {
                    producer = ((QueueSession)session).createSender((Queue)destination);
                }
                if (session instanceof TopicSession) {
                    producer = ((TopicSession)session).createPublisher((Topic)destination);
                }
                throw e;
            }
            return producer;
        }
        catch (JMSException e) {
            throw ConnectorException.exceptionOnGetResource(this, 6, (Exception)((Object)e));
        }
    }
}

