/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.connector.impl;

import java.util.Properties;
import oracle.bpm.configuration.exception.InvalidConfigurationException;
import oracle.bpm.configuration.impl.BaseConfigurationEditorBean;
import oracle.bpm.configuration.util.ValidationUtilities;
import oracle.bpm.connector.impl.PoolConfigurationBean;
import oracle.bpm.lib.msg.LibMsg;

public class JDBC1Configuration
extends BaseConfigurationEditorBean
implements PoolConfigurationBean {
    private int connectionIdleTime;
    private String driverClassName;
    private int entrySize;
    private int maxOpenCursors;
    private int minNoDisposable;
    private String password;
    private int size;
    private String url;
    private String user;

    public JDBC1Configuration(Properties properties) {
        super(properties);
        this.driverClassName = properties.getProperty("jdbc.drivers");
        this.url = properties.getProperty("url");
        this.user = properties.getProperty("user");
        this.password = ValidationUtilities.unscrambleText(properties.getProperty("password"));
        this.size = Integer.parseInt(properties.getProperty("jdbc.pool.max", "10"));
        this.entrySize = Integer.parseInt(properties.getProperty("jdbc.pool.entry.max", "10"));
        this.minNoDisposable = Integer.parseInt(properties.getProperty("jdbc.pool.min", "0"));
        this.maxOpenCursors = Integer.parseInt(properties.getProperty("jdbc.pool.maxopencursors", "100"));
        this.connectionIdleTime = Integer.parseInt(properties.getProperty("jdbc.pool.idle_timeout", "5"));
    }

    @Override
    public Properties getDefaultConnectionProperties() {
        return new Properties();
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public String getDriverClassName() {
        if (this.driverClassName != null) {
            return this.driverClassName.trim();
        }
        return "";
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        if (this.password != null) {
            return this.password;
        }
        return "";
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        if (this.url != null) {
            return this.url;
        }
        return "";
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getUser() {
        if (this.user != null) {
            return this.user;
        }
        return "";
    }

    @Override
    public Properties asProperties() {
        Properties properties = super.asProperties();
        properties.put("jdbc.drivers", this.getDriverClassName());
        properties.put("url", this.getUrl());
        properties.put("user", this.getUser());
        properties.put("password", ValidationUtilities.scrambleText(this.getPassword()));
        properties.put("jdbc.pool.max", String.valueOf(this.getSize()));
        properties.put("jdbc.pool.entry.max", String.valueOf(this.getEntrySize()));
        properties.put("jdbc.pool.min", String.valueOf(this.getMinConnections()));
        properties.put("jdbc.pool.maxopencursors", String.valueOf(this.getMaxOpenCursors()));
        properties.put("jdbc.pool.idle_timeout", String.valueOf(this.getConnectionIdleTime()));
        return properties;
    }

    @Override
    public void check() throws Exception {
    }

    @Override
    public void validate() throws InvalidConfigurationException {
        if (this.getDriverClassName().equals("")) {
            throw InvalidConfigurationException.validationFailed(LibMsg.JDBC_DRIVER.getString());
        }
        if (this.getUrl().trim().equals("")) {
            throw InvalidConfigurationException.validationFailed(LibMsg.URL.getString());
        }
        this.validatePoolValues();
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public void setSize(int size) {
        this.size = size;
    }

    @Override
    public int getMinConnections() {
        return this.minNoDisposable;
    }

    @Override
    public void setMinConnections(int min) {
        this.minNoDisposable = min;
    }

    @Override
    public int getConnectionIdleTime() {
        return this.connectionIdleTime;
    }

    @Override
    public void setConnectionIdleTime(int time) {
        this.connectionIdleTime = time;
    }

    @Override
    public int getEntrySize() {
        return this.entrySize;
    }

    @Override
    public void setEntrySize(int size) {
        this.entrySize = size;
    }

    public void setMaxOpenCursors(int maxOpenCursors) {
        this.maxOpenCursors = maxOpenCursors;
    }

    public int getMaxOpenCursors() {
        return this.maxOpenCursors;
    }

    protected void validatePoolValues() throws InvalidConfigurationException {
        if (this.getSize() <= 0) {
            throw InvalidConfigurationException.validationFailed(LibMsg.POOL_MAX.getString());
        }
        if (this.getMinConnections() < 0) {
            throw InvalidConfigurationException.validationFailed(LibMsg.POOL_MIN.getString());
        }
        if (this.getConnectionIdleTime() < 0) {
            throw InvalidConfigurationException.validationFailed(LibMsg.POOL_IDLE_TIME.getString());
        }
    }
}

