/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.connector.impl;

import java.sql.Connection;
import java.util.List;
import javax.naming.Context;
import javax.transaction.UserTransaction;
import oracle.bpm.connector.impl.BaseTransactionCoordinator;
import oracle.bpm.connector.spi.TransactionConnectorInterface;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.log.Log;

public class J2EETransactionCoordinator
extends BaseTransactionCoordinator {
    private final TransactionConnectorInterface transactionConnector;

    public J2EETransactionCoordinator(TransactionConnectorInterface transactionConnector) {
        this.transactionConnector = transactionConnector;
    }

    @Override
    public String getCoordinatorKey() {
        return this.transactionConnector.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(List resources) throws Exception {
        try {
            UserTransaction tx = this.transactionConnector.getUserTransaction();
            if (tx != null) {
                tx.commit();
            }
        }
        finally {
            this.finishTransaction(resources);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(List resources) throws Exception {
        try {
            UserTransaction tx = this.transactionConnector.getUserTransaction();
            if (tx != null) {
                tx.rollback();
            }
        }
        finally {
            this.finishTransaction(resources);
        }
    }

    void begin() throws Exception {
        UserTransaction tx = this.transactionConnector.getUserTransaction();
        if (tx != null && tx.getStatus() == 6) {
            tx.begin();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishTransaction(List resources) throws Exception {
        try {
            boolean fail = false;
            if (resources != null) {
                for (Object o : resources) {
                    if (o instanceof Context) {
                        try {
                            this.transactionConnector.releaseContext((Context)o);
                        }
                        catch (Throwable t) {
                            Log.logWarning(LibMsg.EXCEPTION_ON_RELEASE_BASEJ2EE(this.getCoordinatorKey()));
                            Log.logWarning(t);
                            fail = true;
                        }
                        continue;
                    }
                    if (o instanceof Connection) {
                        Connection connection = (Connection)o;
                        try {
                            connection.close();
                        }
                        catch (Throwable t) {
                            Log.logWarning(LibMsg.EXCEPTION_ON_RELEASE_BASEJ2EE(this.getCoordinatorKey()));
                            Log.logWarning(t);
                            fail = true;
                        }
                        continue;
                    }
                    if (!Log.isDebugging()) continue;
                    Log.logDebug("Nothing to do with Resource of class " + o.getClass() + " Object:" + o);
                }
            }
            if (fail) {
                throw new Exception();
            }
        }
        finally {
            this.transactionConnector.transactionFinished();
        }
    }
}

