/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.connector.impl;

import java.util.Properties;
import oracle.bpm.configuration.spi.ConfigurationEditorBean;
import oracle.bpm.connector.impl.JNDIConfiguration;

public class J2EEConfiguration
extends JNDIConfiguration
implements ConfigurationEditorBean {
    private String userTransactionLookupName;

    public J2EEConfiguration(Properties properties) {
        super(properties);
        this.setContextFactory(properties.getProperty("java.naming.factory.initial", ""));
        this.userTransactionLookupName = properties.getProperty("javax.user.UserTransaction");
    }

    public void setUserTransactionLookupName(String userTransactionLookupName) {
        this.userTransactionLookupName = userTransactionLookupName;
    }

    public String getUserTransactionLookupName() {
        if (this.userTransactionLookupName != null) {
            return this.userTransactionLookupName;
        }
        return "";
    }

    @Override
    public Properties asProperties() {
        Properties properties = super.asProperties();
        properties.put("javax.user.UserTransaction", this.getUserTransactionLookupName());
        return properties;
    }

    @Override
    public void check() throws Exception {
    }
}

