/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.connector.impl;

import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.sql.XADataSource;
import oracle.bpm.configuration.ConfigType;
import oracle.bpm.connector.ConnectorService;
import oracle.bpm.connector.impl.BaseJDBCConnector;
import oracle.bpm.connector.impl.GenericDatabaseManager;
import oracle.bpm.connector.impl.GenericJdbc1ConfigType;
import oracle.bpm.connector.spi.ConnectorFactory;
import oracle.bpm.jdbc.DatabaseManager;
import oracle.bpm.util.ExceptionFormatter;

public class GenericJDBC1Connector
extends BaseJDBCConnector {
    private GenericDatabaseManager manager;

    GenericJDBC1Connector(ConnectorFactory factory, ConnectorService manager, String name, Properties properties) {
        super(factory, manager, name, properties);
    }

    @Override
    public Properties getConnectionProperties() {
        Properties result = super.getConnectionProperties();
        this.putProperty(result, "user");
        this.putProperty(result, "password", this.getPassword());
        return result;
    }

    @Override
    public DatabaseManager getDatabaseManager() {
        if (this.manager == null) {
            this.manager = new GenericDatabaseManager(this);
        }
        return this.manager;
    }

    @Override
    public String getDriverClass() {
        return this.getProperty("jdbc.drivers");
    }

    @Override
    public ConfigType getConfigType() {
        return GenericJdbc1ConfigType.get();
    }

    @Override
    public String getURL() {
        return this.getProperty("url");
    }

    @Override
    public boolean handleServiceType(String type) {
        return "SQL".equals(type);
    }

    @Override
    public void restart() {
    }

    @Override
    public void stop() {
    }

    @Override
    protected XADataSource getXADataSource() throws SQLException {
        try {
            Class<?> clazz = Class.forName(this.getProperty("jdbc.xa.driverclass"));
            XADataSource xadatasource = (XADataSource)clazz.newInstance();
            Properties xaProperties = GenericJDBC1Connector.getXAProperties(this.getProperty("jdbc.xa.properties"));
            for (String string : xaProperties.keySet()) {
                String value = xaProperties.getProperty(string);
                if (string.length() <= 0) continue;
                String string2 = string.substring(0, 1).toUpperCase() + (string.length() == 1 ? "" : string.substring(1));
                Method method = clazz.getMethod("set" + string2, String.class);
                Object[] args = new Object[]{value};
                method.invoke((Object)xadatasource, args);
            }
            return xadatasource;
        }
        catch (Exception e) {
            throw new SQLException(ExceptionFormatter.fullTechLevel(e));
        }
    }

    private static Properties getXAProperties(String semicolonSeparated) {
        Properties xaproperties = new Properties();
        StringTokenizer tokenizer = new StringTokenizer(semicolonSeparated, ";");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            int index = token.lastIndexOf("=");
            if (index <= 0) continue;
            String key = token.substring(0, index).trim();
            String value = token.substring(index + 1).trim();
            xaproperties.put(key, value);
        }
        return xaproperties;
    }
}

