/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.connector.impl;

import oracle.bpm.component.ExecutionThread;
import oracle.bpm.connector.ConnectionPoolMonitor;
import oracle.bpm.pool.CacheStatistic;
import oracle.bpm.pool.ConnectionPoolMonitorUpdateListener;

public class ConnectionPoolMonitorImpl
implements ConnectionPoolMonitor,
ConnectionPoolMonitorUpdateListener {
    private String configurationName;
    private CacheStatistic statistic;

    public ConnectionPoolMonitorImpl(String configurationName, CacheStatistic statistic) {
        this.configurationName = configurationName;
        this.statistic = statistic;
        this.statistic.setConnectionPoolMonitorUpdateListener(this);
    }

    @Override
    public void notifyDBConnections() {
        ExecutionThread.ResourcesUsage resourcesUsage = ExecutionThread.getResourcesUsage();
        if (resourcesUsage != null) {
            resourcesUsage.refreshDBConnections(this.getSize() > 0 ? this.getLockedConnections() * 100 / this.getSize() : 0, this.getConfigurationName());
        }
    }

    @Override
    public String getConfigurationName() {
        return this.configurationName;
    }

    @Override
    public int getEmptySlots() {
        return this.statistic.getEmpty();
    }

    @Override
    public int getTTL() {
        return this.statistic.getTTL();
    }

    @Override
    public int getLockedConnections() {
        return this.statistic.getConnectionsLocked();
    }

    @Override
    public int getMinNonDisposable() {
        return this.statistic.getMinNoDisposable();
    }

    @Override
    public int getNotLockedConnections() {
        return this.statistic.getNotLocked();
    }

    @Override
    public int getSize() {
        return this.statistic.getEntryCapacity();
    }

    @Override
    public int getTotalLocked() {
        return this.statistic.getTotalLocked();
    }

    @Override
    public int getTotalUnLocked() {
        return this.statistic.getTotalUnLocked();
    }

    @Override
    public int getMissCount() {
        return this.statistic.getMissCount();
    }
}

