/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.configuration.impl;

import java.util.Properties;
import oracle.bpm.configuration.exception.InvalidConfigurationException;
import oracle.bpm.configuration.spi.ConfigurationEditorBean;
import oracle.bpm.lib.msg.LibMsg;

public abstract class RemoteConfiguration
implements ConfigurationEditorBean {
    private String j2eeConnector;
    private String lookupName;

    protected RemoteConfiguration(Properties properties) {
        this.lookupName = properties.getProperty("lookupName");
        this.j2eeConnector = properties.getProperty("j2ee.provider");
    }

    public void setJ2eeConnector(String j2eeConnector) {
        this.j2eeConnector = j2eeConnector;
    }

    public String getJ2eeConnector() {
        if (this.j2eeConnector != null) {
            return this.j2eeConnector;
        }
        return "";
    }

    public void setLookupName(String lookupName) {
        this.lookupName = lookupName;
    }

    public String getLookupName() {
        if (this.lookupName != null) {
            return this.lookupName;
        }
        return "";
    }

    @Override
    public Properties asProperties() {
        Properties properties = new Properties();
        properties.put("lookupName", this.getLookupName());
        properties.put("j2ee.provider", this.getJ2eeConnector());
        return properties;
    }

    @Override
    public void validate() throws InvalidConfigurationException {
        if (this.getJ2eeConnector().trim().equals("")) {
            throw InvalidConfigurationException.validationFailed(LibMsg.J2EE_CONNECTOR.getString());
        }
        if (this.getLookupName().trim().equals("")) {
            throw InvalidConfigurationException.validationFailed(LibMsg.LOOKUP_NAME.getString());
        }
    }
}

