/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.configuration.impl;

import java.util.Properties;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.configuration.exception.InvalidConfigurationException;
import oracle.bpm.configuration.spi.ConfigurationEditorBean;
import oracle.bpm.lib.msg.LibMsg;

public class JavaClassLibraryConfiguration
implements ConfigurationEditorBean {
    private StringList fileNames;
    private boolean versionable;
    public static final String FILE_PROPERTY_KEY = "FILE";
    private static final String FILES_SEPARATOR = ":";

    public JavaClassLibraryConfiguration(Properties properties) {
        this.fileNames = StringList.createTokenizing(properties.getProperty(FILE_PROPERTY_KEY), FILES_SEPARATOR);
        this.versionable = Boolean.parseBoolean(properties.getProperty("jcl.versionable"));
    }

    public void setFileNames(StringList fileNames) {
        this.fileNames = fileNames;
    }

    public StringList getFileNames() {
        return this.fileNames;
    }

    public void setVersionable(boolean versionable) {
        this.versionable = versionable;
    }

    public boolean isVersionable() {
        return this.versionable;
    }

    @Override
    public Properties asProperties() {
        Properties properties = new Properties();
        properties.put(FILE_PROPERTY_KEY, this.fileNames.toSeparatedString(FILES_SEPARATOR));
        properties.put("jcl.versionable", String.valueOf(this.versionable));
        return properties;
    }

    @Override
    public void check() throws Exception {
    }

    @Override
    public void validate() throws InvalidConfigurationException {
        if (this.getFileNames().isEmpty()) {
            throw InvalidConfigurationException.validationFailed(LibMsg.JCL_LIBRARY_REQUIRED);
        }
    }
}

