/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.configuration.impl;

import java.util.Map;
import java.util.Properties;
import oracle.bpm.configuration.spi.ConfigurationEditorBean;

public abstract class BaseConfigurationEditorBean
implements ConfigurationEditorBean {
    protected Properties additionalProperties;

    public BaseConfigurationEditorBean(Properties properties) {
        this.additionalProperties = this.getAdditionalFromProperties(properties);
    }

    public abstract Properties getDefaultConnectionProperties();

    public Properties getAdditionalFromProperties(Properties properties) {
        Properties p = new Properties();
        for (Map.Entry<Object, Object> entry1 : properties.entrySet()) {
            String key = (String)entry1.getKey();
            Object value = entry1.getValue();
            if (!key.startsWith("custom.")) continue;
            key = key.substring("custom.".length());
            p.put(key, value);
        }
        Properties defaultProperties = this.getDefaultConnectionProperties();
        for (Map.Entry<Object, Object> entry2 : defaultProperties.entrySet()) {
            String key = (String)entry2.getKey();
            Object value = entry2.getValue();
            if (p.containsKey(key)) continue;
            p.put(key, value);
        }
        return p;
    }

    public void setAdditionalProperties(Properties aditionalProperties) {
        this.additionalProperties = aditionalProperties;
    }

    public Properties getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public Properties asProperties() {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.addPrefixToProperties());
        return properties;
    }

    protected Properties addPrefixToProperties() {
        Properties p = new Properties();
        for (Map.Entry<Object, Object> entry1 : this.getAdditionalProperties().entrySet()) {
            String key = (String)entry1.getKey();
            Object value = entry1.getValue();
            p.put("custom." + key, value);
        }
        return p;
    }
}

