/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.configuration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.bpm.extension.Extension;
import oracle.bpm.extension.ExtensionService;
import oracle.bpm.extensionpoint.metadata.ConfigTypeMetadata;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.Platform;
import oracle.bpm.log.Log;
import oracle.bpm.resources.Msg;

public class ConfigType
implements Comparable {
    private ConfigType defaultSubType;
    private boolean group;
    private Msg msg;
    private String name;
    private ConfigType parent;
    private Map<String, ConfigType> subtypes = new HashMap<String, ConfigType>();
    private long supports;

    protected ConfigType(String name, Msg msg) {
        this.name = name;
        this.msg = msg;
        this.group = false;
    }

    public static List<ConfigType> getTypes() {
        return ConfigType.getRoot().getSubTypes();
    }

    public static List<ConfigType> getAccesibleTypes() {
        return ConfigType.getRoot().getAccesibleSubTypes();
    }

    public static void check(ConfigType type) {
        assert (type != null) : "Null type";
        assert (type.getName() != null) : "Null name" + type;
        assert (type.getParent() == null || type.getMsg() != null) : "Null message: " + type;
    }

    public static ConfigType find(String ... names) {
        ConfigType current = ConfigType.getRoot();
        if (current != null && names != null && names.length > 0) {
            for (String n : names) {
                if (n == null || n.length() == 0 || (current = current.getSubType(n)) == null) break;
            }
        }
        return current;
    }

    public Msg getMsg() {
        return this.msg != null ? this.msg : (this.getParent() != null ? this.getParent().getMsg() : null);
    }

    public String getName() {
        return this.name;
    }

    public final ConfigType getParent() {
        return this.parent;
    }

    public final ConfigType getBaseType() {
        ConfigType current = this;
        ConfigType parent;
        while ((parent = current.getParent()) != null && parent != ConfigType.getRoot()) {
            current = parent;
        }
        return current;
    }

    public boolean isGroup() {
        return this.group;
    }

    public void setGroup(boolean group) {
        this.group = group;
    }

    public void setSupports(long supports) {
        this.supports = supports;
    }

    public final boolean isSubType() {
        return this.getParent() != null;
    }

    public boolean supportHeirs() {
        return true;
    }

    public boolean supports(long featureMask) {
        return (this.supports & featureMask) == featureMask;
    }

    public final boolean equals(Object other) {
        boolean result = false;
        if (other instanceof ConfigType) {
            ConfigType otherType = (ConfigType)other;
            result = this.getName().equals(otherType.getName()) && Any.equals(this.getParent(), otherType.getParent());
        }
        return result;
    }

    public final int hashCode() {
        int result = 54;
        result = 29 * result + this.getName().hashCode();
        if (this.getParent() != null) {
            result = 29 * result + this.getParent().hashCode();
        }
        return result;
    }

    public ConfigType getDefaultSubType() {
        return this.defaultSubType != null ? this.defaultSubType : this.subtypes.values().iterator().next();
    }

    public void addSubType(ConfigType type) {
        if (type.getParent() != null && type.getParent() != this) {
            throw new IllegalArgumentException("ConfigType already added to: " + type.getParent());
        }
        type.setParent(this);
        this.subtypes.put(type.getName(), type);
    }

    public final ConfigType getSubType(String name) {
        return this.subtypes.get(name);
    }

    public final ConfigType getSubType(String ... names) {
        ConfigType current = this;
        if (names != null && names.length > 0) {
            String n;
            String[] arr$ = names;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (current = current.getSubType(n = arr$[i$])) != null; ++i$) {
            }
        }
        return current;
    }

    public final List<ConfigType> getSubTypes() {
        return new ArrayList<ConfigType>(this.subtypes.values());
    }

    public final Set getSubTypesNames() {
        return Collections.unmodifiableSet(this.subtypes.keySet());
    }

    public final List<ConfigType> getSubTypesThatSupports(long feature) {
        ArrayList<ConfigType> result = new ArrayList<ConfigType>();
        for (ConfigType subType : this.subtypes.values()) {
            if (!subType.supports(feature)) continue;
            result.add(subType);
        }
        return result;
    }

    public final List<ConfigType> getAccesibleSubTypes() {
        ArrayList<ConfigType> result = new ArrayList<ConfigType>();
        for (ConfigType subType : this.subtypes.values()) {
            if (subType.supports(0x8000000L)) continue;
            result.add(subType);
        }
        return result;
    }

    public int compareTo(Object o) {
        if (o instanceof ConfigType) {
            return this.getName().compareTo(((ConfigType)o).getName());
        }
        return 0;
    }

    public boolean hasSubTypes() {
        return !this.subtypes.isEmpty();
    }

    public String getQualifiedName() {
        String qname = "";
        for (ConfigType type = this; type != null && type != ConfigType.getRoot(); type = type.getParent()) {
            qname = qname.length() == 0 ? type.getName() : type.getName() + '/' + qname;
        }
        return qname;
    }

    public final String toString() {
        String result = this.getParent() == null ? (this.getMsg() != null ? this.getMsg().toString() : this.getName()) : (this.getMsg().equals(this.getParent().getMsg()) ? this.getMsg().toString() : this.getName());
        return result;
    }

    protected void setParent(ConfigType parent) {
        this.parent = parent;
    }

    void setDefaultSubType(ConfigType subType) {
        assert (subType.getParent() == this);
        this.defaultSubType = subType;
    }

    private static ConfigType getRoot() {
        return RootHolder.VALUE;
    }

    private static ConfigType loadConfigurations() {
        ConfigType result = new ConfigType("<root>", null);
        ExtensionService service = Platform.getExtensionService();
        List<Extension<ConfigTypeMetadata>> extensions = service.getExtensionsByPoint(ConfigTypeMetadata.class);
        ArrayList<Extension<ConfigTypeMetadata>> copy = new ArrayList<Extension<ConfigTypeMetadata>>(extensions);
        boolean addedConfigs = true;
        while (addedConfigs && !copy.isEmpty()) {
            addedConfigs = false;
            Iterator it = copy.iterator();
            while (it.hasNext()) {
                Extension extension = (Extension)it.next();
                try {
                    ConfigTypeMetadata configTypeMetadata = (ConfigTypeMetadata)extension.getMetadata();
                    String[] parentPath = configTypeMetadata.parent();
                    if (parentPath != null && parentPath.length > 0) {
                        ConfigType parent = result.getSubType(parentPath);
                        if (parent == null) continue;
                        ConfigType config = parent.getSubType(configTypeMetadata.name());
                        if (config == null) {
                            config = extension.instantiateAs(ConfigType.class);
                            parent.addSubType(config);
                        }
                        addedConfigs = true;
                        it.remove();
                        continue;
                    }
                    ConfigType config = extension.instantiateAs(ConfigType.class);
                    config.setGroup(configTypeMetadata.group());
                    if (result.getSubType(configTypeMetadata.name()) == null) {
                        result.addSubType(config);
                        config.setParent(null);
                    }
                    addedConfigs = true;
                    it.remove();
                }
                catch (InstantiationException instantiationException) {
                    Log.logSevere(instantiationException);
                    it.remove();
                }
            }
        }
        if (!copy.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            for (Extension extension : copy) {
                ConfigTypeMetadata metadata = (ConfigTypeMetadata)extension.getMetadata();
                builder.append("Cannot register configuration '").append(metadata.name()).append("' because parent ").append(Arrays.asList(metadata.parent())).append(" is not registered.\n");
            }
            throw new IllegalStateException(builder.toString());
        }
        return result;
    }

    static /* synthetic */ ConfigType access$000() {
        return ConfigType.loadConfigurations();
    }

    private static final class RootHolder {
        static final ConfigType VALUE = ConfigType.access$000();

        private RootHolder() {
        }
    }
}

