/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.configuration;

import java.io.File;
import java.io.InputStream;
import java.util.StringTokenizer;
import oracle.bpm.configuration.BaseConfiguration;
import oracle.bpm.configuration.ConfigurationManager;
import oracle.bpm.configuration.ConfigurationRuntimeException;
import oracle.bpm.configuration.ConfigurationSet;
import oracle.bpm.configuration.JarRepository;
import oracle.bpm.configuration.KnownConfigTypes;
import oracle.bpm.io.FileSystem;
import oracle.bpm.io.StreamUtils;
import org.jetbrains.annotations.Nullable;

public abstract class BaseFileManager<T extends BaseConfiguration>
extends ConfigurationManager<T> {
    private FileSystem fileSystem;

    protected BaseFileManager(ConfigurationSet<T> configurations, FileSystem fileSystem) {
        super(configurations);
        this.fileSystem = fileSystem;
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    public void configRemoved(T configuration) {
        if (configuration.getBaseConfigType().equals(KnownConfigTypes.JCL)) {
            File file = this.getLibDir();
            JarRepository jarRep = new JarRepository(file, this);
            String files = configuration.getProperty("FILE");
            if (files != null) {
                if (files.indexOf(58) != -1) {
                    StringTokenizer tokenizer = new StringTokenizer(files, ":");
                    while (tokenizer.hasMoreElements()) {
                        jarRep.deleteJar(tokenizer.nextToken());
                    }
                } else {
                    jarRep.deleteJar(files);
                }
            }
        }
    }

    protected abstract File getFile();

    @Nullable
    protected abstract InputStream reloadData() throws Exception;

    protected abstract void saveConfigurations() throws Exception;

    @Override
    protected void persistConfigurations() {
        try {
            if (this.getFileSystem() != null) {
                this.getFileSystem().create(this.getFile());
            }
            this.saveConfigurations();
        }
        catch (Exception e) {
            throw ConfigurationRuntimeException.cannotCreateManager(this.getFile(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void reloadNewConfigurations() {
        block5: {
            try {
                InputStream inputStream = this.reloadData();
                if (inputStream == null) break block5;
                try {
                    ConfigurationSet configSet = ConfigurationSet.create(inputStream);
                    for (BaseConfiguration configuration : configSet.values()) {
                        this.internalSaveConfiguration(configuration);
                    }
                }
                catch (Throwable throwable) {
                    StreamUtils.close(inputStream);
                    throw throwable;
                }
                StreamUtils.close(inputStream);
            }
            catch (Exception e) {
                throw ConfigurationRuntimeException.cannotCreateManager(this.getFile(), e);
            }
        }
    }
}

