/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.components;

import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageEOFException;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.jms.Topic;
import oracle.bpm.component.metadata.Component;
import oracle.bpm.component.metadata.Exclude;
import oracle.bpm.component.metadata.Type;
import oracle.bpm.components.JmsDeliveryMode;
import oracle.bpm.components.JmsMessageType;
import oracle.bpm.lang.Time;

@Component(module="Fuego.Msg")
public class JmsMessage
implements Serializable {
    private byte[] bytesValue;
    private String correlationId;
    private JmsDeliveryMode deliveryMode;
    private String destination;
    private Time expiration;
    private String jmsType;
    private HashMap<String, Object> mapValue;
    private String messageId;
    private Serializable objectValue;
    private int priority;
    private HashMap<String, String> properties;
    private boolean redelivered;
    private String replyTo;
    private ArrayList streamValue;
    private String textValue;
    private Time timestamp;
    private JmsMessageType type;
    static final long serialVersionUID = -1261485232478826989L;
    static final long serialCheck = 6412497340397920184L;

    public JmsMessage(JmsMessageType type) {
        this.properties = new HashMap();
        this.type = type;
    }

    @Exclude
    public JmsMessage(Message src) throws JMSException {
        this.loadFromMessage(src);
    }

    @Exclude
    public void loadFromMessage(Message src) throws JMSException {
        this.messageId = src.getJMSMessageID();
        this.timestamp = this.getJmsTime(src.getJMSTimestamp());
        this.correlationId = src.getJMSCorrelationID();
        this.replyTo = this.getDestinationName(src.getJMSReplyTo());
        this.destination = this.getDestinationName(src.getJMSDestination());
        this.redelivered = src.getJMSRedelivered();
        this.jmsType = src.getJMSType();
        this.expiration = this.getJmsTime(src.getJMSTimestamp());
        this.priority = src.getJMSPriority();
        this.deliveryMode = JmsDeliveryMode.valueOf(src.getJMSDeliveryMode());
        this.properties = this.buildProperties(src);
        this.loadBody(src);
    }

    public void setBytesValue(byte[] bytesValue) {
        this.bytesValue = bytesValue;
    }

    public byte[] getBytesValue() {
        return this.bytesValue;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public JmsDeliveryMode getDeliveryMode() {
        return this.deliveryMode;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setExpiration(Time expiration) {
        this.expiration = expiration;
    }

    public Time getExpiration() {
        return this.expiration;
    }

    public String getJmsType() {
        return this.jmsType;
    }

    public void setMapValue(HashMap<String, Object> mapValue) {
        this.mapValue = mapValue;
    }

    @Type(value="Any[String]")
    public HashMap<String, Object> getMapValue() {
        return this.mapValue;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setObjectValue(Serializable objectValue) {
        this.objectValue = objectValue;
    }

    @Type(value="Any")
    public Serializable getObjectValue() {
        return this.objectValue;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setProperties(HashMap<String, String> properties) {
        this.properties = properties;
    }

    @Type(value="String[String]")
    public HashMap<String, String> getProperties() {
        return this.properties;
    }

    public boolean getRedelivered() {
        return this.redelivered;
    }

    public void setReplyTo(String relayToDestination) {
        this.replyTo = relayToDestination;
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    public void setStreamValue(ArrayList streamValue) {
        this.streamValue = streamValue;
    }

    @Type(value="Any[]")
    public ArrayList getStreamValue() {
        return this.streamValue;
    }

    public void setTextValue(String textValue) {
        this.textValue = textValue;
    }

    public String getTextValue() {
        return this.textValue;
    }

    public Time getTimestamp() {
        return this.timestamp;
    }

    public JmsMessageType getType() {
        return this.type;
    }

    private String getDestinationName(Destination jmsDestination) throws JMSException {
        String name = null;
        if (jmsDestination instanceof Topic) {
            Topic topic = (Topic)jmsDestination;
            name = topic.getTopicName();
        } else if (jmsDestination instanceof Queue) {
            Queue queue = (Queue)jmsDestination;
            name = queue.getQueueName();
        }
        return name;
    }

    private Time getJmsTime(long ms) {
        Time result = null;
        if (ms != 0L) {
            result = Time.valueOf(ms * 1000L);
        }
        return result;
    }

    private HashMap<String, String> buildProperties(Message src) throws JMSException {
        HashMap<String, String> props = new HashMap<String, String>();
        Enumeration propertyNames = src.getPropertyNames();
        while (propertyNames.hasMoreElements()) {
            String name = (String)propertyNames.nextElement();
            props.put(name, src.getStringProperty(name));
        }
        return props;
    }

    private void loadBody(Message src) throws JMSException {
        if (src instanceof TextMessage) {
            TextMessage textMessage = (TextMessage)src;
            this.type = JmsMessageType.TEXT;
            this.textValue = textMessage.getText();
        } else if (src instanceof ObjectMessage) {
            ObjectMessage objectMessage = (ObjectMessage)src;
            this.type = JmsMessageType.OBJECT;
            this.objectValue = objectMessage.getObject();
        } else if (src instanceof BytesMessage) {
            int read;
            BytesMessage byteMessage = (BytesMessage)src;
            this.type = JmsMessageType.BYTES;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buf = new byte[512];
            while ((read = byteMessage.readBytes(buf)) != -1) {
                baos.write(buf, 0, read);
            }
            this.bytesValue = baos.toByteArray();
        } else if (src instanceof MapMessage) {
            MapMessage mapMessage = (MapMessage)src;
            this.type = JmsMessageType.MAP;
            this.mapValue = new HashMap();
            Enumeration keys = mapMessage.getMapNames();
            while (keys.hasMoreElements()) {
                String name = (String)keys.nextElement();
                this.mapValue.put(name, mapMessage.getObject(name));
            }
        } else if (src instanceof StreamMessage) {
            StreamMessage streamMessage = (StreamMessage)src;
            this.type = JmsMessageType.STREAM;
            this.streamValue = new ArrayList();
            try {
                while (true) {
                    this.streamValue.add(streamMessage.readObject());
                }
            }
            catch (MessageEOFException messageEOFException) {}
        } else {
            throw new JMSException("Unsupported message type received: " + src.getClass().getName());
        }
    }
}

