/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.components;

import fuego.directory.DirCalendarRule;
import fuego.directory.DirectoryException;
import fuego.directory.DirectorySession;
import java.util.Calendar;
import java.util.GregorianCalendar;
import oracle.bpm.component.metadata.Component;
import oracle.bpm.component.metadata.Method;
import oracle.bpm.components.CalendarRuleException;
import oracle.bpm.components.ProcessInstance;
import oracle.bpm.components.Role;
import oracle.bpm.components.Server;
import oracle.bpm.lang.Day;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Time;
import oracle.bpm.lang.WorkDaySchedule;

@Component(module="Fuego.Lib")
public class CalendarRule {
    private final oracle.bpm.util.CalendarRule baseCalendar;

    public CalendarRule() {
        this(CalendarRule.getActiveCalendarRule());
    }

    private CalendarRule(oracle.bpm.util.CalendarRule calendarRule) {
        this.baseCalendar = calendarRule;
    }

    @Method(result="calendarRule")
    public static CalendarRule fetch(String calendarName) throws CalendarRuleException {
        DirCalendarRule dirCalendar;
        DirectorySession session;
        try {
            session = Server.getDirectorySession();
            dirCalendar = DirCalendarRule.fetch(session, calendarName);
        }
        catch (DirectoryException e) {
            throw new CalendarRuleException(e);
        }
        oracle.bpm.util.CalendarRule utilCalendar = oracle.bpm.util.CalendarRule.getCalendarRule(session, dirCalendar);
        if (utilCalendar == null) {
            return null;
        }
        return new CalendarRule(utilCalendar);
    }

    @Method(result="allCalendars")
    public static CalendarRule[] fetchAll() throws CalendarRuleException {
        DirCalendarRule[] allDirCals;
        DirectorySession session;
        try {
            session = Server.getDirectorySession();
            allDirCals = DirCalendarRule.fetchAll(session);
        }
        catch (DirectoryException e) {
            throw new CalendarRuleException(e);
        }
        CalendarRule[] result = new CalendarRule[allDirCals.length];
        for (int i = 0; i < allDirCals.length; ++i) {
            result[i] = new CalendarRule(oracle.bpm.util.CalendarRule.getCalendarRule(session, allDirCals[i]));
        }
        return result;
    }

    @Method(result="newdate")
    public static Time add(Time date, Interval interval) {
        return new CalendarRule().computeDate(date, interval);
    }

    @Method(result="workDays")
    public int elapsedDays(Time fromDate, Time toDate) {
        boolean doSwap;
        if (this.baseCalendar == null) {
            return toDate.getDays() - fromDate.getDays();
        }
        GregorianCalendar fromCal = this.toJavaCalendarDate(fromDate);
        GregorianCalendar toCal = this.toJavaCalendarDate(toDate);
        boolean bl = doSwap = fromCal.getTimeInMillis() > toCal.getTimeInMillis();
        if (doSwap) {
            GregorianCalendar aux = fromCal;
            fromCal = toCal;
            toCal = aux;
        }
        int result = 0;
        GregorianCalendar cal = fromCal;
        while (cal.getTimeInMillis() < toCal.getTimeInMillis()) {
            if (this.isWorkDate(cal) && !this.isHoliday(cal)) {
                ++result;
            }
            ((Calendar)cal).add(5, 1);
        }
        return doSwap ? -result : result;
    }

    @Method(result="newdate")
    public Time computeDate(Time date, Interval interval) {
        return this.baseCalendar != null ? this.baseCalendar.computeDate(date, interval) : Time.add(date, interval);
    }

    @Method(result="startLaborTime")
    public Time startTime(Time time) {
        if (this.baseCalendar == null) {
            return Time.valueOf(time.getYear(), time.getMonth(), time.getDay(), 0, 0, 0, 0);
        }
        GregorianCalendar calendar = this.toJavaCalendarDate(time);
        if (!this.isWorkDate(calendar) || this.isHoliday(calendar)) {
            return null;
        }
        return this.baseCalendar.computeDate(Time.valueOf(calendar.getTime()), Interval.ZERO);
    }

    @Method(result="endLaborTime")
    public Time closeTime(Time time) {
        WorkDaySchedule wds;
        if (this.baseCalendar == null) {
            return Time.valueOf(time.getYear(), time.getMonth(), time.getDay(), 23, 59, 0, 0);
        }
        GregorianCalendar calendar = this.toJavaCalendarDate(time);
        if (!this.isWorkDate(calendar) || this.isHoliday(calendar)) {
            return null;
        }
        Time fTime = wds.getFinishTime((wds = this.baseCalendar.getWorkWeek().getSchedule(Day.valueOf(calendar))).hasShift(1) ? 1 : 0);
        calendar.set(11, fTime.getHourOfDay());
        calendar.set(12, fTime.getMinute());
        calendar.set(13, fTime.getSecond());
        return Time.valueOf(calendar.getTime());
    }

    @Method(result="nextCloseTime")
    public Time nextWorkDayCloseTime(Time time) {
        return this.closeTime(this.nextWorkDayStartTime(time));
    }

    @Method(result="nextStartTime")
    public Time nextWorkDayStartTime(Time time) {
        if (this.baseCalendar == null) {
            return Time.add(Time.valueOf(time.getYear(), time.getMonth(), time.getDay(), 0, 0, 0, 0), Interval.ONE_DAY);
        }
        return this.baseCalendar.computeDate(Time.valueOf(this.toJavaCalendarDate(time).getTime()), Interval.ONE_DAY);
    }

    @Method(result="holiday")
    public boolean isHoliday(Time time) {
        return this.baseCalendar != null && this.isHoliday(this.toJavaCalendarDate(time));
    }

    @Method(result="workDate")
    public boolean isWorkDate(Time time) {
        return this.baseCalendar == null || this.isWorkDate(this.toJavaCalendarDate(time));
    }

    private static oracle.bpm.util.CalendarRule getActiveCalendarRule() {
        ProcessInstance serverexec = ProcessInstance.getCurrent();
        Role actRole = serverexec.getActivity().getRole();
        return serverexec.getBean().getCalendarRule(ProcessInstance.getOrganization(), ProcessInstance.getOrganizationalUnit(), actRole != null ? actRole.getName() : null, ProcessInstance.getDirectorySession());
    }

    private GregorianCalendar toJavaCalendarDate(Time time) {
        GregorianCalendar result = new GregorianCalendar(this.baseCalendar.getTimeZone());
        result.setTime(time.dateValue());
        result.set(11, 0);
        result.set(12, 0);
        result.set(13, 0);
        result.set(14, 0);
        return result;
    }

    private boolean isHoliday(Calendar cal) {
        return this.baseCalendar.getHolidayCalendar().isHoliday(cal);
    }

    private boolean isWorkDate(Calendar cal) {
        return this.baseCalendar.getWorkWeek().isWorkingDay(cal);
    }
}

