/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.components;

import fuego.papi.exception.ProcessNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Locale;
import oracle.bpm.component.metadata.Component;
import oracle.bpm.component.metadata.EnterpriseOnly;
import oracle.bpm.component.metadata.Exclude;
import oracle.bpm.component.metadata.Hidden;
import oracle.bpm.components.ActivityInterface;
import oracle.bpm.components.ActivityRetryThrowable;
import oracle.bpm.components.InstanceRetrieverInterface;
import oracle.bpm.components.NoSuchActivityException;
import oracle.bpm.components.Participant;
import oracle.bpm.components.Process;
import oracle.bpm.components.ProcessInstance;
import oracle.bpm.components.ProcessInstanceInterface;
import oracle.bpm.components.ProcessInterface;
import oracle.bpm.components.Role;
import oracle.bpm.components.RoleInterface;
import oracle.bpm.components.Server;
import oracle.bpm.lang.DynamicObject;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Time;
import oracle.bpm.lib.msg.LibMsg;

@Component(module="Fuego.Lib", runsOnClient=false)
public class Activity
implements Serializable {
    private transient ActivityInterface activity_d;
    private transient ProcessInstanceInterface pdata;
    private transient Process process_d;
    private transient Role role_d;
    static final long serialVersionUID = 2436111523630347613L;
    static final long serialCheck = 2076872211313653779L;

    @Hidden
    public Activity() {
    }

    @Exclude
    public Activity(ActivityInterface activity) {
        this.activity_d = activity;
    }

    public Activity(String name) throws NoSuchActivityException {
        ProcessInterface process = ProcessInstance.getProcess().getProcess();
        this.activity_d = process.getActivityInterface(name);
        if (this.activity_d == null) {
            throw NoSuchActivityException.activityNotFound(name);
        }
    }

    @Hidden
    public boolean isAbortable() {
        return this.getActivityInterface().isAbortable();
    }

    public boolean isAutoComplete() {
        return this.getActivityInterface().isAutoComplete();
    }

    public boolean isAutomatic() {
        return this.getActivityInterface().isAutomatic();
    }

    public final Time getDeadline() {
        return this.pdata == null ? null : this.pdata.getActivityDeadline();
    }

    public final Activity getSource() {
        return this.pdata == null ? null : this.pdata.getSourceActivityComponent();
    }

    public String getDescription() {
        return this.getActivityInterface().getDescription();
    }

    public String getDocumentation() {
        return this.getActivityInterface().getDocumentation();
    }

    @Hidden
    public boolean isGlobalInstance() {
        return this.getActivityInterface().isGlobalInstance();
    }

    public boolean getHasMultipleTransitions() {
        return this.getActivityInterface().hasMultipleTransitions();
    }

    public String getLabel() {
        return this.getActivityInterface().getLabel();
    }

    public String getLabel(Locale locale) {
        return this.getActivityInterface().getLabel(locale);
    }

    public String getLevel() {
        return this.getActivityInterface().getLevel();
    }

    public String getName() {
        return this.getActivityInterface().getName();
    }

    public Process getProcess() {
        if (this.process_d == null) {
            this.process_d = new Process(this.getActivityInterface().getProcessInterface());
        }
        return this.process_d;
    }

    @Exclude
    public void setProcessInterface(ProcessInstanceInterface pdata) {
        this.pdata = pdata;
    }

    public Role getRole() {
        if (this.getProcess().isProcedure()) {
            return ProcessInstance.getCurrent().getDynamicRole();
        }
        if (this.role_d == null) {
            RoleInterface roleInterface = this.activity_d.getRoleInterface();
            this.role_d = roleInterface != null ? new Role(roleInterface) : null;
        }
        return this.role_d;
    }

    public boolean isSuspendable() {
        return this.getActivityInterface().isSuspendable();
    }

    public boolean getUserSelectsTransition() {
        return this.getActivityInterface().getUserSelectsTransition();
    }

    @Deprecated
    @EnterpriseOnly
    @Hidden
    public ArrayList retrieveInstances() {
        return this.instancesImpl(2);
    }

    @Deprecated
    @EnterpriseOnly
    @Hidden
    public ArrayList retrievePendingInstances() {
        return this.instancesImpl(0);
    }

    @Deprecated
    @EnterpriseOnly
    @Hidden
    public ArrayList retrieveSelectedInstances(Participant participant) {
        return this.selectedInstancesImpl(2, participant);
    }

    @Deprecated
    @EnterpriseOnly
    @Hidden
    public ArrayList retrieveSelectedPendingInstances(Participant participant) {
        return this.selectedInstancesImpl(0, participant);
    }

    @Deprecated
    @EnterpriseOnly
    @Hidden
    public ArrayList retrieveSelectedSuspendedInstances(Participant participant) {
        return this.selectedInstancesImpl(1, participant);
    }

    @Deprecated
    @EnterpriseOnly
    @Hidden
    public ArrayList retrieveSuspendedInstances() {
        return this.instancesImpl(1);
    }

    @Deprecated
    @EnterpriseOnly
    @Hidden
    public ArrayList retrieveUnselectedInstances() {
        return this.unselectedInstancesImpl(2);
    }

    @Deprecated
    @EnterpriseOnly
    @Hidden
    public ArrayList retrieveUnselectedPendingInstances() {
        return this.unselectedInstancesImpl(0);
    }

    @Deprecated
    @EnterpriseOnly
    @Hidden
    public ArrayList retrieveUnselectedSuspendedInstances() {
        return this.unselectedInstancesImpl(1);
    }

    public void retry(Interval interval) throws ActivityRetryThrowable {
        throw new ActivityRetryThrowable(interval);
    }

    public void retry(Time time) throws ActivityRetryThrowable {
        throw new ActivityRetryThrowable(time);
    }

    @Hidden
    public String toString() {
        return "Activity(" + this.getName() + ")";
    }

    protected DynamicObject writeDynamicObject() {
        DynamicObject dobj = DynamicObject.create();
        String activityId = this.getName();
        String processId = this.getProcess().getId();
        dobj.setField("name", activityId);
        dobj.setField("process", processId);
        return dobj;
    }

    static Object readDynamicObject(DynamicObject dobj) throws ProcessNotFoundException {
        String activityId = dobj.getField("name").toString();
        String processId = dobj.getField("process").toString();
        ActivityInterface activityInterface = Activity.loadActivity(processId, activityId);
        return new Activity(activityInterface);
    }

    @Hidden
    ProcessInterface getProcessInterface() {
        return this.getActivityInterface().getProcessInterface();
    }

    private static ActivityInterface loadActivity(String processId, String activityId) throws ProcessNotFoundException {
        ProcessInterface process = Server.getServerInterface().findProcessInCache(processId);
        if (process != null) {
            ActivityInterface activity = process.getActivityInterface(activityId);
            if (activity != null) {
                return activity;
            }
            throw NoSuchActivityException.activityNotFound(activityId);
        }
        throw new ProcessNotFoundException(processId);
    }

    private ActivityInterface getActivityInterface() {
        if (this.activity_d == null) {
            try {
                this.activity_d = ProcessInstance.getCurrent().getActivity().getActivityInterface();
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException(LibMsg.MUST_RUN_SERVER_SIDE.getString());
            }
        }
        return this.activity_d;
    }

    @Hidden
    private ArrayList instancesImpl(int type) {
        InstanceRetrieverInterface instanceRetrieverInterface = ProcessInstance.getCurrent().getInstanceRetrieverInterface();
        return instanceRetrieverInterface.getInstancesForActivity(type, this.getActivityInterface());
    }

    private void readObject(ObjectInputStream in) throws IOException {
        String activityId = in.readUTF();
        String processId = in.readUTF();
        try {
            this.activity_d = Activity.loadActivity(processId, activityId);
        }
        catch (ProcessNotFoundException e) {
            IOException ioException = new IOException();
            ioException.initCause(e);
            throw ioException;
        }
    }

    @Hidden
    private ArrayList selectedInstancesImpl(int type, Participant participant) {
        InstanceRetrieverInterface instanceRetrieverInterface = ProcessInstance.getCurrent().getInstanceRetrieverInterface();
        return instanceRetrieverInterface.getSelectedInstancesForActivity(type, participant.participantInterface(), this.getActivityInterface());
    }

    @Hidden
    private ArrayList unselectedInstancesImpl(int type) {
        InstanceRetrieverInterface instanceRetrieverInterface = ProcessInstance.getCurrent().getInstanceRetrieverInterface();
        return instanceRetrieverInterface.getUnselectedInstancesForActivity(type, this.getActivityInterface());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        String activityId = this.getName();
        String processId = this.getProcess().getId();
        out.writeUTF(activityId);
        out.writeUTF(processId);
    }
}

