/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.component;

import java.io.Serializable;
import oracle.bpm.lang.Time;

public class QueueInfo
implements Serializable {
    private long latency;
    private long median;
    private long oldest;
    private int size;
    private long timeStamp;
    private int used;
    private long youngest;
    static final long serialVersionUID = -2407315428164143803L;
    static final long serialCheck = -8255462548655496679L;

    public QueueInfo(int size, int used, long oldest, long youngest, long median, long latency) {
        this.size = size;
        this.used = used;
        this.oldest = oldest;
        this.youngest = youngest;
        this.median = median;
        this.latency = latency;
        this.timeStamp = System.currentTimeMillis();
    }

    public long getLatency() {
        return this.latency;
    }

    public long getMedian() {
        return this.median;
    }

    public long getOldest() {
        return this.oldest;
    }

    public int getSize() {
        return this.size;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public int getUsed() {
        return this.used;
    }

    public long getYoungest() {
        return this.youngest;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("QueueInfo[size=");
        sb.append(this.size);
        sb.append(", used=");
        sb.append(this.used);
        sb.append(", ts=");
        sb.append(Time.valueOf(this.timeStamp * 1000L));
        sb.append("]");
        return sb.toString();
    }
}

