/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.component;

import java.lang.reflect.InvocationTargetException;
import oracle.bpm.component.Instantiator;
import oracle.bpm.component.InstantiatorFactoryExtension;
import oracle.bpm.lang.ComponentExecutionException;
import oracle.bpm.lang.Invokeable;
import oracle.bpm.lang.JavaClass;
import oracle.bpm.lang.JavaObject;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.type.FuegoClass;

public class JavaInstantiator
extends Instantiator {
    private InstantiatorFactoryExtension factory;

    public JavaInstantiator(InstantiatorFactoryExtension factory) {
        this.factory = factory;
    }

    @Override
    public Invokeable instantiate(String qualifiedName, String classname) throws ClassNotFoundException, ComponentExecutionException {
        String defaultConstructor = 'K' + classname + "()";
        return this.instantiate(qualifiedName, classname, defaultConstructor, null);
    }

    @Override
    public Invokeable instantiate(String qualifiedName, String classname, String constructor, Object[] args) throws ClassNotFoundException, ComponentExecutionException {
        try {
            JavaClass<Object> javaClass;
            Instantiator.Initializer init;
            block13: {
                init = this.factory.getInitializer();
                int lparens = constructor.indexOf(40);
                if (lparens == -1) {
                    throw new IllegalArgumentException("Illegal constructor signature: " + constructor);
                }
                classname = constructor.substring(1, lparens);
                if (init != null) {
                    classname = init.replaceClass(classname);
                }
                constructor = 'K' + classname + constructor.substring(lparens);
                javaClass = null;
                try {
                    javaClass = JavaClass.forName(classname);
                }
                catch (ClassNotFoundException e) {
                    ObjectTypeDescription otd = FuegoClass.forName(qualifiedName);
                    Class aClass = otd.getJavaClass();
                    if (aClass != null) {
                        javaClass = JavaClass.fromClass(aClass);
                    }
                    if (javaClass != null) break block13;
                    throw e;
                }
            }
            int length = args != null ? args.length : 0;
            Object[] realArgs = new Object[length / 2];
            if (args != null) {
                int i = 0;
                int j = 0;
                while (i < realArgs.length) {
                    realArgs[i] = args[j + 1];
                    ++i;
                    j += 2;
                }
            }
            Object target = javaClass.newInstance(constructor, realArgs);
            Invokeable object = new JavaObject<Object>(javaClass, target);
            if (init != null) {
                object = init.initialize(classname, object);
            }
            return object;
        }
        catch (NoSuchMethodException e) {
            throw new ComponentExecutionException(e, classname, "constructor");
        }
        catch (InvocationTargetException e) {
            throw new ComponentExecutionException(e, classname, "constructor");
        }
        catch (InstantiationException e) {
            throw new ComponentExecutionException(e, classname, "constructor");
        }
        catch (IllegalAccessException e) {
            throw new ComponentExecutionException(e, classname, "constructor");
        }
    }
}

