/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.component;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import oracle.bpm.component.Batch;
import oracle.bpm.component.CILSecurityContext;
import oracle.bpm.component.Component;
import oracle.bpm.component.ExecutionThreadContext;
import oracle.bpm.component.FullQueueException;
import oracle.bpm.component.Message;
import oracle.bpm.component.PoolInfo;
import oracle.bpm.component.PoolParameters;
import oracle.bpm.component.PoolStatsCommand;
import oracle.bpm.component.Principal;
import oracle.bpm.component.QueueInfo;
import oracle.bpm.component.Request;
import oracle.bpm.component.RequestDispatcher;
import oracle.bpm.component.Response;
import oracle.bpm.component.SimpleRequest;
import oracle.bpm.component.Task;
import oracle.bpm.http.HttpCommandServer;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.log.Log;
import oracle.bpm.util.ExceptionFormatter;
import oracle.bpm.util.StackTrace;

public class ExecutionThread
extends Thread
implements InvocationHandler {
    private ExecutionThreadContext context;
    private boolean doDispatch;
    private int groupIndex;
    private int poolIndex;
    private Request request;
    private final Object requestLock = new Object();
    private volatile Response response;
    private CILSecurityContext securityCtx;
    private static ResourcesUsage resourcesUsage;
    private static final Long ZERO;
    private static final ExecutionThreadGroup group;
    private static int nextName;
    private static int priority;
    private static final int REMOVED = -1;
    private static RequestDispatcher dispatcher;
    private static final Object poolLock;
    private static ExecutionThread[] pool;
    private static int[] groupConstraints;
    private static int[] groupCounters;
    private static int head;
    private static int free;
    private static int tail;
    private static final Object rogueLock;
    private static int rogueCounter;
    private static int rogueLimit;
    private static Emergency emergency;

    private ExecutionThread() {
        super((ThreadGroup)group, "ET(" + nextName++ + ")");
        this.setPriority(priority);
        this.setDaemon(true);
        this.doDispatch = true;
    }

    public static void setEmergencyHandler(Emergency obj) {
        if (obj != null && emergency != null) {
            throw new IllegalStateException("An emergency listener has already been set");
        }
        emergency = obj;
    }

    public static PoolParameters getPoolParameters() {
        PoolInfo info = ExecutionThread.createPoolInfo();
        QueueInfo queueInfo = info.getQueueInfo();
        return new PoolParameters(queueInfo.getSize(), queueInfo.getLatency(), info.getRogueLimit(), info.getConstraints());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isThreadAvailable(int group) {
        Object object = poolLock;
        synchronized (object) {
            if (group < 0 || group >= groupConstraints.length) {
                throw new IllegalArgumentException("Illegal group number: " + group);
            }
            return groupCounters[group] < groupConstraints[group];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PoolInfo createPoolInfo() {
        QueueInfo q;
        int[] counters;
        int[] constraints;
        int rc;
        int rl;
        int l;
        int f;
        int t;
        int h;
        Object object = poolLock;
        synchronized (object) {
            h = head;
            t = tail;
            f = free;
            l = pool.length;
            Object object2 = rogueLock;
            synchronized (object2) {
                rl = rogueLimit;
                rc = rogueCounter;
            }
            constraints = new int[groupConstraints.length];
            System.arraycopy(groupConstraints, 0, constraints, 0, groupConstraints.length);
            counters = new int[groupCounters.length];
            System.arraycopy(groupCounters, 0, counters, 0, groupCounters.length);
            q = dispatcher.createQueueInfo();
        }
        int size = l - 1;
        int free = h <= f ? f - h : f + (l - h);
        int busy = f <= t ? t - f : t + (l - f);
        int unused = size - free - busy;
        return new PoolInfo(size, free, busy, unused, constraints, counters, q, rl, rc);
    }

    public static Batch doProcessBatch(Principal principal, Batch requests) {
        return ExecutionThread.doProcessBatch(principal, requests, 0);
    }

    public static Batch doProcessBatch(Principal principal, Batch requests, int group) {
        Thread current = ExecutionThread.currentThread();
        if (current instanceof ExecutionThread) {
            return ((ExecutionThread)current).processBatch(requests);
        }
        try {
            SimpleRequest request = new SimpleRequest(principal, requests.get().getId(), requests, group);
            ExecutionThread.enqueue(request);
            return request.waitResult();
        }
        catch (FullQueueException e) {
            Batch b = new Batch();
            b.add(Message.createException(requests.get().getId(), e));
            return b;
        }
    }

    public static void enqueue(Request request) throws FullQueueException {
        Integer id;
        if (dispatcher == null) {
            ExecutionThread.setup(new PoolParameters());
        }
        if ((id = request.getId()) == null || id.equals(ExecutionThreadContext.NEW)) {
            dispatcher.enqueue(request);
        } else {
            ExecutionThreadContext.wakeup(request);
        }
    }

    public static Object executeTask(Task task, Principal principal, int group) throws Exception {
        Thread thread = ExecutionThread.currentThread();
        if (thread instanceof ExecutionThread) {
            return task.run();
        }
        Batch batch = new Batch();
        batch.add(Message.createTask(task));
        SimpleRequest request = new SimpleRequest(principal, ExecutionThreadContext.NEW, batch, group);
        boolean threadFound = ExecutionThread.processRequest(request, 0L);
        assert (threadFound) : "No more threads available";
        batch = request.waitResult();
        Message message = batch.get();
        if (message.isException()) {
            Throwable t = (Throwable)message.getValue();
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            assert (false) : "unexpected exception: " + t;
            return null;
        }
        if (message.isReturnValue()) {
            return message.getValue();
        }
        assert (false) : "unexpected message type: " + message;
        return null;
    }

    public static boolean processRequest(Request request, long timeout) {
        ExecutionThread thread = ExecutionThread.findAvailableThread(request.getGroup(), timeout);
        if (thread == null) {
            return false;
        }
        thread.addRequest(request);
        return true;
    }

    public static void processRequest(Request item) {
        ExecutionThread.processRequest(item, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setup(PoolParameters params) {
        int queueSize = params.getRequestQueueSize();
        int[] requested = params.createConstraints();
        long latency = params.getMaxRequestLatency();
        int rogue = params.getRogueThreadsLimit();
        if (requested == null || requested.length < 1) {
            throw new IllegalArgumentException("you must setup at least one group");
        }
        if (rogue < 0) {
            throw new IllegalArgumentException("the rogue thread limit cannot be less than zero");
        }
        Object object = poolLock;
        synchronized (object) {
            Object object2 = rogueLock;
            synchronized (object2) {
                if (rogue < rogueCounter) {
                    rogue = rogueCounter + 1;
                }
                rogueLimit = rogue;
            }
            if (pool == null) {
                int total = 0;
                for (int i = 0; i < requested.length; ++i) {
                    total += requested[i];
                }
                pool = new ExecutionThread[total + 1];
                groupConstraints = new int[requested.length];
                groupCounters = new int[requested.length];
                System.arraycopy(requested, 0, groupConstraints, 0, requested.length);
                HttpCommandServer.getDefault().register(new PoolStatsCommand());
                ExecutionThreadContext.initWatches();
                dispatcher = new RequestDispatcher(queueSize, latency);
                dispatcher.start();
            } else {
                int howMany;
                int size;
                if (groupConstraints.length != requested.length) {
                    throw new IllegalArgumentException("You cannot change the number of groups once the pool has been initialized");
                }
                int poolLength = pool.length;
                int poolSize = poolLength - 1;
                int nBusy = free <= tail ? tail - free : tail + (poolLength - free);
                int nFree = head <= free ? free - head : free + (poolLength - head);
                int nUnused = poolSize - nFree - nBusy;
                int total = 0;
                int[] constraints = new int[groupConstraints.length];
                for (int i = 0; i < requested.length; ++i) {
                    constraints[i] = Math.max(requested[i], groupCounters[i]);
                    total += constraints[i];
                }
                int available = nFree + nUnused;
                if (total + 1 < poolLength) {
                    int difference = poolLength - (total + 1);
                    assert (difference <= available) : "We should have enough (free+unused) threads for shrinking";
                    size = total + 1;
                    howMany = nFree < size ? nFree : available - difference;
                } else {
                    size = total + 1;
                    howMany = nFree;
                }
                ExecutionThread[] tmp = new ExecutionThread[size];
                int t = ExecutionThread.moveBusy(tmp);
                ExecutionThread.moveFree(howMany, tmp);
                free = size - 1;
                tail = t;
                head = size - howMany - 1;
                pool = tmp;
                groupConstraints = constraints;
                dispatcher.configure(queueSize, latency);
            }
            ExecutionThread.invariant();
        }
        ExecutionThread.notifyExecution();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdownPool() {
        dispatcher.stop();
        Object object = poolLock;
        synchronized (object) {
            ExecutionThread.moveFree(0, null);
        }
        ExecutionThreadContext.abortAll();
    }

    public static ResourcesUsage getResourcesUsage() {
        return resourcesUsage;
    }

    public static void setResourcesUsage(ResourcesUsage resources) {
        resourcesUsage = resources;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        ExecutionThreadContext context = this.getContext();
        return context != null ? context.getTimeToLive() : ZERO.longValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.work();
        }
        catch (StackOverflowError s) {
            try {
                Log.logSevere(LibMsg.ET_REPLACED(this.toString(), ExceptionFormatter.fullTechLevel(s), StackTrace.getStackTrace()));
            }
            finally {
                ExecutionThread.remove(this);
            }
        }
        catch (VirtualMachineError vme) {
            Emergency emergency = ExecutionThread.emergency;
            if (emergency != null) {
                emergency.handleVirtualMachineError(vme);
            } else {
                Log.logFatal(vme);
            }
        }
        catch (Throwable t) {
            try {
                Log.logSevere(LibMsg.ET_REPLACED(this.toString(), ExceptionFormatter.fullTechLevel(t), StackTrace.getStackTrace()));
            }
            finally {
                ExecutionThread.remove(this);
            }
        }
    }

    public long getTimeToLive() {
        ExecutionThreadContext context = this.getContext();
        return context != null ? context.getTimeToLive() : 0L;
    }

    public ExecutionThreadContext getContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void release(ExecutionThread thread) {
        Object object = poolLock;
        synchronized (object) {
            int index = thread.poolIndex;
            if (index == -1) {
                return;
            }
            assert (pool[index] == thread) : "Thread has the wrong poolIndex";
            free = (free + 1) % pool.length;
            ExecutionThread tmp = pool[free];
            ExecutionThread.pool[ExecutionThread.free] = pool[index];
            ExecutionThread.pool[ExecutionThread.free].poolIndex = free;
            ExecutionThread.pool[index] = tmp;
            ExecutionThread.pool[index].poolIndex = index;
            int n = thread.groupIndex;
            groupCounters[n] = groupCounters[n] - 1;
            ExecutionThread.invariant();
            poolLock.notifyAll();
        }
        ExecutionThread.notifyExecution();
    }

    int getGroup() {
        if (ExecutionThread.currentThread() != this) {
            throw new IllegalStateException("This method must be called from " + this);
        }
        return this.groupIndex;
    }

    CILSecurityContext getSecurityContext() {
        SecurityManager sm;
        if (this.securityCtx == null && (sm = System.getSecurityManager()) != null) {
            this.securityCtx = (CILSecurityContext)sm.getSecurityContext();
        }
        return this.securityCtx;
    }

    void setResponse(Response response) {
        this.response = response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove() {
        float percentage;
        int totalRogueThreads;
        Emergency emergency = ExecutionThread.emergency;
        Object object = rogueLock;
        synchronized (object) {
            if (++rogueCounter > rogueLimit && emergency != null && rogueLimit > 0) {
                emergency.tooManyRogueThreads(rogueLimit);
            }
            totalRogueThreads = rogueCounter;
            percentage = (float)totalRogueThreads * 100.0f / (float)rogueLimit;
        }
        this.dismiss();
        ExecutionThread.remove(this);
        if (emergency != null) {
            emergency.newRogueThread(totalRogueThreads, this.getName(), this.getStackTrace(), percentage);
        }
    }

    void sendResult(Batch responses) {
        assert (this.response != null) : "Response can't be null";
        this.response.put(responses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ExecutionThread findAvailableThread(int group, long timeout) {
        ExecutionThread thread;
        long start = System.currentTimeMillis();
        Object object = poolLock;
        synchronized (object) {
            if (group < 0 || group >= groupConstraints.length) {
                throw new IllegalArgumentException("Illegal group number: " + group);
            }
            while (true) {
                int size;
                int length = pool.length;
                int n = size = head <= tail ? tail - head : tail + (length - head);
                if (groupConstraints[group] > groupCounters[group]) {
                    if (free != head) {
                        thread = pool[free];
                        assert (thread != null) : "thread cannot be null";
                        free = (free == 0 ? length : free) - 1;
                        break;
                    }
                    if (size < length - 1) {
                        thread = new ExecutionThread();
                        thread.start();
                        ExecutionThread.pool[ExecutionThread.head] = thread;
                        ExecutionThread.pool[ExecutionThread.head].poolIndex = head;
                        free = head = (head == 0 ? length : head) - 1;
                        break;
                    }
                }
                long elapsed = System.currentTimeMillis() - start;
                long ttl = timeout - elapsed;
                if (timeout == 0L) {
                    ttl = 0L;
                } else if (ttl <= 0L) {
                    return null;
                }
                try {
                    poolLock.wait(ttl);
                }
                catch (InterruptedException e) {
                    Log.logSevere(e);
                    return null;
                }
            }
            thread.groupIndex = group;
            int n = group;
            groupCounters[n] = groupCounters[n] + 1;
            ExecutionThread.invariant();
        }
        ExecutionThread.notifyExecution();
        return thread;
    }

    private static void invariant() {
        int length = pool.length;
        assert (head >= 0 && head < length && tail >= 0 && tail < length && free >= 0 && free < length && (head <= free && free <= tail || free <= tail && tail <= head || tail <= head && head <= free)) : "Class invariant violation: head=" + head + ", free=" + free + ", tail=" + tail;
    }

    private static int moveBusy(ExecutionThread[] tmp) {
        int t = tmp.length - 1;
        int i = tail;
        while (i != free) {
            t = (t + 1) % tmp.length;
            tmp[t] = pool[i];
            tmp[t].poolIndex = t;
            i = (i == 0 ? pool.length : i) - 1;
        }
        return t;
    }

    private static void moveFree(int howMany, ExecutionThread[] tmp) {
        assert (tmp != null || howMany == 0) : "tmp can only be null if howMany is zero";
        assert (tmp == null || howMany < tmp.length) : "howMany (" + howMany + ") should be smaller than tmp.newLen (" + tmp.length + ")";
        int i = free;
        while (i != head) {
            if (howMany > 0) {
                assert (tmp != null) : "tmp cannot be null";
                int index = tmp.length - howMany;
                tmp[index] = pool[i];
                tmp[index].poolIndex = index;
                --howMany;
            } else {
                pool[i].dismiss();
            }
            i = (i == 0 ? pool.length : i) - 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void remove(ExecutionThread thread) {
        Object object = poolLock;
        synchronized (object) {
            int index = thread.poolIndex;
            if (index == -1) {
                return;
            }
            assert (pool[index] == thread) : "Thread has the wrong poolIndex";
            ExecutionThread.pool[index] = pool[tail];
            ExecutionThread.pool[index].poolIndex = index;
            ExecutionThread.pool[ExecutionThread.tail] = null;
            thread.poolIndex = -1;
            tail = (tail == 0 ? pool.length : tail) - 1;
            int n = thread.groupIndex;
            groupCounters[n] = groupCounters[n] - 1;
            ExecutionThread.invariant();
            poolLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyExecution() {
        int maxFblThreads;
        int maxHttpThreads;
        int maxInteractiveThreads;
        int maxAutomaticThreads;
        int fblThreadsInUse;
        int httpThreadsInUse;
        int interactiveThreadsInUse;
        int automaticThreadsInUse;
        assert (groupCounters != null && groupCounters.length == 4 && groupConstraints != null && groupConstraints.length == 4);
        Object object = poolLock;
        synchronized (object) {
            automaticThreadsInUse = groupCounters[1];
            interactiveThreadsInUse = groupCounters[0];
            httpThreadsInUse = groupCounters[2];
            fblThreadsInUse = groupCounters[3];
            maxAutomaticThreads = groupConstraints[1];
            maxInteractiveThreads = groupConstraints[0];
            maxHttpThreads = groupConstraints[2];
            maxFblThreads = groupConstraints[3];
        }
        if (resourcesUsage != null) {
            resourcesUsage.refreshAutomaticThreads(maxAutomaticThreads > 0 ? automaticThreadsInUse * 100 / maxAutomaticThreads : 0);
            resourcesUsage.refreshInteractiveThreads(maxInteractiveThreads > 0 ? interactiveThreadsInUse * 100 / maxInteractiveThreads : 0);
            resourcesUsage.refreshHTTPThreads(maxHttpThreads > 0 ? httpThreadsInUse * 100 / maxHttpThreads : 0);
            resourcesUsage.refreshFBLThreads(maxFblThreads > 0 ? fblThreadsInUse * 100 / maxFblThreads : 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRequest(Request requests) {
        Object object = this.requestLock;
        synchronized (object) {
            assert (this.request == null && this.response == null) : "request and response should be null";
            this.response = requests.getResponse();
            this.request = requests;
            this.requestLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dismiss() {
        this.doDispatch = false;
        Object object = this.requestLock;
        synchronized (object) {
            this.requestLock.notify();
        }
    }

    private Batch processBatch(Batch requests) {
        while (!requests.isEmpty()) {
            this.processMessage(requests.remove());
        }
        return this.context.clearResponses();
    }

    private void processMessage(Message message) {
        if (message == null) {
            return;
        }
        this.context.setRunning();
        Runnable runnable = message.getRunnable();
        if (runnable != null) {
            runnable.run();
        } else {
            Throwable t;
            Message result = message.process(this.context.getTarget());
            assert (result.isReturnValue() || result.isException()) : "result must be an exception or a return value";
            this.context.addResponse(result);
            if (result.isException() && (t = (Throwable)result.getValue()) instanceof Error) {
                throw (Error)t;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void work() throws InterruptedException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            this.securityCtx = (CILSecurityContext)sm.getSecurityContext();
        }
        while (this.doDispatch) {
            Batch responses;
            Object principal;
            Request request;
            Object object = this.requestLock;
            synchronized (object) {
                while (this.request == null) {
                    this.requestLock.wait();
                    if (this.doDispatch) continue;
                    return;
                }
                request = this.request;
                this.request = null;
            }
            assert (this.context == null) : "Context should be null";
            boolean hung = false;
            Component.setLocation("SERVER");
            try {
                principal = request.getPrincipal();
                this.context = principal.createContext();
                assert (this.context != null) : "Context cannot be null";
                responses = principal.processBatch(request.getBatch());
                if (!this.context.inRelay() && !this.context.isHung()) {
                    this.sendResult(responses);
                }
            }
            catch (Throwable e) {
                responses = new Batch();
                responses.add(Message.createException(this.context == null ? ExecutionThreadContext.NEW : this.context.getId(), e));
                if (this.context == null || !this.context.isHung()) {
                    this.sendResult(responses);
                }
                if (e instanceof Error) {
                    throw (Error)e;
                }
            }
            finally {
                if (this.context != null) {
                    hung = this.context.isHung();
                    this.context.dispose();
                    this.context = null;
                }
                if (hung) {
                    principal = rogueLock;
                    synchronized (principal) {
                        --rogueCounter;
                    }
                }
            }
            this.response = null;
            if (hung) continue;
            ExecutionThread.release(this);
        }
    }

    static {
        ZERO = 0L;
        group = new ExecutionThreadGroup();
        nextName = 0;
        priority = 5;
        poolLock = new Object();
        head = 0;
        free = 0;
        tail = 0;
        rogueLock = new Object();
        rogueCounter = 0;
    }

    private static class ExecutionThreadGroup
    extends ThreadGroup {
        public ExecutionThreadGroup() {
            super("Execution Thread Pool");
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            Log.logFatal(e);
        }
    }

    public static interface ResourcesUsage
    extends ConnectionPoolUsage {
        public void refreshAutomaticThreads(int var1);

        public void refreshInteractiveThreads(int var1);

        public void refreshHTTPThreads(int var1);

        public void refreshFBLThreads(int var1);

        public void refreshToDoQueueFilling(long var1);
    }

    public static interface Emergency {
        public void handleVirtualMachineError(VirtualMachineError var1);

        public void tooManyRogueThreads(int var1);

        public void newRogueThread(int var1, String var2, StackTraceElement[] var3, float var4);
    }

    public static interface ConnectionPoolUsage {
        public void refreshDBConnections(int var1, String var2);
    }
}

