/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.component;

import oracle.bpm.component.Wanderer;
import oracle.bpm.lang.ComponentExecutionException;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Invokeable;
import oracle.bpm.lang.Uncaughtable;

public class ExecutionRelayedThrowable
extends Throwable
implements Uncaughtable {
    private Object[] bindings;
    private Object caller;
    private Object[] inputArguments;
    private String methodSignature;
    private Invokeable target;
    private String targetCil;
    static final long serialVersionUID = 3101924228589480596L;
    static final long serialCheck = 7044604590788547437L;

    public ExecutionRelayedThrowable(Invokeable target, String methodSignature, Object[] inputArguments, String targetCil, Object[] bindings) {
        this(null, target, methodSignature, inputArguments, targetCil, bindings);
    }

    public ExecutionRelayedThrowable(Object caller, Invokeable target, String methodSignature, Object[] inputArguments, String targetCil, Object[] bindings) {
        if (caller instanceof Wanderer) {
            this.caller = caller;
        }
        this.target = target;
        this.methodSignature = methodSignature;
        this.inputArguments = inputArguments;
        this.targetCil = targetCil;
        this.bindings = bindings;
    }

    public static ExecutionRelayedThrowable relayTo(Invokeable target, Object caller, String methodSignature, Object[] inputArguments, String targetCil, Object[] bindings) {
        return new ExecutionRelayedThrowable(caller, target, methodSignature, inputArguments, targetCil, bindings);
    }

    public Object[] getBindings() {
        return this.bindings;
    }

    public Object[] getInputArguments() {
        return this.inputArguments;
    }

    @Override
    public String getMessage() {
        return "targetCil: " + this.targetCil;
    }

    public String getMethodSignature() {
        return this.methodSignature;
    }

    public Invokeable getTarget() {
        return this.target;
    }

    public String getTargetCil() {
        return this.targetCil;
    }

    public Interval getTimeout() {
        return (Interval)this.target.getAttributeValue("Atimeout;", null, 0);
    }

    public void execute() throws ComponentExecutionException {
        try {
            this.target.invokeRelayTo(this.methodSignature, this.inputArguments, this.caller, this.targetCil, this.bindings);
        }
        catch (Exception e) {
            throw new ComponentExecutionException(e);
        }
    }
}

