/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.component;

import java.util.Locale;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.resources.I18nProvider;
import oracle.bpm.resources.Msg;

public enum ExecutionContextState implements I18nProvider
{
    STARTED(LibMsg.STARTED),
    RUNNING(LibMsg.RUNNING),
    WAITING_CLIENT(LibMsg.WAITING_CLIENT),
    RELAY(LibMsg.RELAY),
    FINISHED(LibMsg.FINISHED),
    ABORTING(LibMsg.ABORTING),
    ABORTED(LibMsg.ABORTED),
    TIMED_OUT(LibMsg.TIMED_OUT);

    private transient Msg msg;

    private ExecutionContextState(Msg msg) {
        this.msg = msg;
    }

    static ExecutionContextState forId(int state) {
        switch (state) {
            case 0: {
                return STARTED;
            }
            case 1: {
                return RUNNING;
            }
            case 2: {
                return WAITING_CLIENT;
            }
            case 3: {
                return RELAY;
            }
            case 4: {
                return FINISHED;
            }
            case 5: {
                return ABORTING;
            }
            case 6: {
                return ABORTED;
            }
            case 7: {
                return TIMED_OUT;
            }
        }
        throw new IllegalArgumentException("Unknown state: " + state);
    }

    @Override
    public String getString() {
        return this.getMsg().getString();
    }

    @Override
    public String getString(Locale locale) {
        return this.getMsg().getString(locale);
    }

    public Msg getMsg() {
        return this.msg;
    }
}

